/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import org.jamon.api.Location;
import org.jamon.codegen.AbstractInnerUnit;
import org.jamon.codegen.ArgNames;
import org.jamon.codegen.ClassNames;
import org.jamon.codegen.CodeWriter;
import org.jamon.codegen.FragmentArgument;
import org.jamon.codegen.GenericParams;
import org.jamon.codegen.OptionalArgument;
import org.jamon.codegen.StatementBlock;
import org.jamon.compiler.ParserErrorsImpl;
import org.jamon.node.OptionalArgNode;

public class FragmentUnit
extends AbstractInnerUnit {
    static final String DEFAULT_FRAGMENT_NAME = "";
    private final GenericParams genericParams;

    public FragmentUnit(String name, StatementBlock parent, GenericParams genericParams, ParserErrorsImpl errors, Location location) {
        super(name, parent, errors, location);
        this.genericParams = genericParams;
    }

    public String getFragmentInterfaceName(boolean makeGeneric) {
        String genericParamsClause;
        String string = genericParamsClause = makeGeneric ? this.genericParams.generateGenericParamsList() : DEFAULT_FRAGMENT_NAME;
        if (this.getParent() instanceof AbstractInnerUnit) {
            return "Fragment_" + this.getParentUnit().getName() + "__jamon__" + this.getName() + genericParamsClause;
        }
        return "Fragment_" + this.getName() + genericParamsClause;
    }

    @Override
    public void addOptionalArg(OptionalArgNode node) {
        this.getErrors().addError("Fragments cannot have optional arguments", node.getValue().getLocation());
    }

    @Override
    public void addOptionalArg(OptionalArgument arg) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void addFragmentArg(FragmentArgument arg) {
        this.getErrors().addError("Fragments cannot have fragment arguments", arg.getLocation());
    }

    @Override
    public FragmentUnit getFragmentUnitIntf(String path) {
        return this.getParent().getFragmentUnitIntf(path);
    }

    public void printInterface(CodeWriter writer, String interfaceModifiers, boolean isCopy) {
        writer.println(interfaceModifiers + " static interface " + this.getFragmentInterfaceName(true));
        if (isCopy) {
            writer.println("  extends Intf." + this.getFragmentInterfaceName(true));
        }
        writer.openBlock();
        if (!isCopy) {
            writer.print("void renderNoFlush");
            writer.openList();
            writer.printListElement(ArgNames.WRITER_DECL);
            this.printRenderArgsDecl(writer);
            writer.closeList();
            writer.println();
            writer.println("  throws java.io.IOException;");
            writer.print(ClassNames.RENDERER + " makeRenderer");
            writer.openList();
            this.printRenderArgsDecl(writer);
            writer.closeList();
            writer.println(";");
        }
        writer.closeBlock();
        writer.println();
    }

    public void generateThrowsIOExceptionIfNecessary(CodeWriter writer) {
        if (this.doesIO()) {
            writer.println(" throws " + ClassNames.IOEXCEPTION);
        }
    }
}

