/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import org.jamon.api.Location;
import org.jamon.codegen.AbstractStatement;
import org.jamon.codegen.CodeWriter;
import org.jamon.codegen.TemplateDescriber;
import org.jamon.util.StringUtils;

public class LiteralStatement
extends AbstractStatement {
    private final StringBuilder text;

    LiteralStatement(String text, Location token, String templateIdentifier) {
        super(token, templateIdentifier);
        this.text = new StringBuilder(text);
    }

    public void appendText(String text) {
        this.text.append(text);
    }

    @Override
    public void generateSource(CodeWriter writer, TemplateDescriber describer) {
        if (this.text.length() > 0) {
            this.generateSourceLine(writer);
            writer.print("jamonWriter.write(\"");
            this.javaEscape(this.text.toString(), writer);
            writer.println("\");");
        }
    }

    private void javaEscape(String string, CodeWriter writer) {
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    writer.print("\\\\");
                    continue block7;
                }
                case '\n': {
                    writer.print("\\n");
                    continue block7;
                }
                case '\r': {
                    writer.print("\\r");
                    continue block7;
                }
                case '\t': {
                    writer.print("\\t");
                    continue block7;
                }
                case '\"': {
                    writer.print("\\\"");
                    continue block7;
                }
                default: {
                    char ci = c;
                    if (ci < ' ' || ci > '\u007f') {
                        writer.print("\\u");
                        writer.print(StringUtils.hexify4(ci));
                        continue block7;
                    }
                    writer.print(Character.valueOf(c));
                }
            }
        }
    }

    public String getText() {
        return this.text.toString();
    }
}

