/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import org.jamon.codegen.AbstractArgument;
import org.jamon.codegen.CodeWriter;
import org.jamon.node.OptionalArgNode;
import org.jamon.util.StringUtils;

public class OptionalArgument
extends AbstractArgument {
    private String defaultValue;

    public OptionalArgument(OptionalArgNode arg) {
        super(arg);
        this.defaultValue = arg.getValue().getValue();
    }

    public OptionalArgument(String name, String type, String defaultValue) {
        super(name, type, null);
        this.defaultValue = defaultValue;
    }

    public void setDefault(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDefault() {
        return this.defaultValue;
    }

    public String getIsNotDefaultName() {
        return "get" + StringUtils.capitalize(this.getName()) + "__IsNotDefault";
    }

    @Override
    public void generateImplDataCode(CodeWriter writer) {
        super.generateImplDataCode(writer);
        writer.println("public boolean " + this.getIsNotDefaultName() + "()");
        writer.openBlock();
        writer.println("return m_" + this.getName() + "__IsNotDefault;");
        writer.closeBlock();
        writer.println("private boolean m_" + this.getName() + "__IsNotDefault;");
    }

    @Override
    protected void generateImplDataSetterCode(CodeWriter writer) {
        super.generateImplDataSetterCode(writer);
        writer.println("m_" + this.getName() + "__IsNotDefault = true;");
    }

    public String toString() {
        return "OptionalArg: {name => " + this.getName() + ", type => " + this.getType() + ", defualt => " + this.getDefault() + "}";
    }
}

