/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import java.util.Map;
import org.jamon.compiler.ParserErrorsImpl;
import org.jamon.node.AbsolutePathNode;
import org.jamon.node.DepthFirstAnalysisAdapter;
import org.jamon.node.NamedAliasPathNode;
import org.jamon.node.PathElementNode;
import org.jamon.node.RootAliasPathNode;
import org.jamon.node.UpdirNode;

class PathAdapter
extends DepthFirstAnalysisAdapter {
    private final String templateDir;
    private final Map<String, String> aliases;
    private final ParserErrorsImpl errors;
    private final StringBuilder path = new StringBuilder();
    private boolean absolutePath = false;

    public PathAdapter(String templateDir, Map<String, String> aliases, ParserErrorsImpl errors) {
        this.templateDir = templateDir;
        this.aliases = aliases;
        this.errors = errors;
    }

    public String getPath() {
        return this.path.substring(0, this.path.length() - 1);
    }

    @Override
    public void inAbsolutePathNode(AbsolutePathNode node) {
        this.absolutePath = true;
        this.path.append('/');
    }

    @Override
    public void inUpdirNode(UpdirNode updir) {
        int lastSlash;
        if (!this.absolutePath) {
            this.path.insert(0, this.templateDir);
            this.absolutePath = true;
        }
        if ((lastSlash = this.path.toString().lastIndexOf(47, this.path.length() - 2)) < 0) {
            this.errors.addError("Cannot reference templates above the root", updir.getLocation());
        }
        this.path.delete(lastSlash + 1, this.path.length());
    }

    @Override
    public void inPathElementNode(PathElementNode relativePath) {
        this.path.append(relativePath.getName());
        this.path.append('/');
    }

    @Override
    public void inNamedAliasPathNode(NamedAliasPathNode node) {
        String alias = this.aliases.get(node.getAlias());
        if (alias == null) {
            this.errors.addError("Unknown alias " + node.getAlias(), node.getLocation());
        } else {
            this.path.append(alias);
            this.path.append('/');
        }
    }

    @Override
    public void inRootAliasPathNode(RootAliasPathNode node) {
        String alias = this.aliases.get("/");
        if (alias == null) {
            this.errors.addError("No root alias", node.getLocation());
        } else {
            this.path.append(alias);
            this.path.append('/');
        }
    }
}

