/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import org.jamon.util.StringUtils;

public class PathUtils {
    private PathUtils() {
    }

    public static String getIntfClassName(String path) {
        int i = path.lastIndexOf(47);
        return i < 0 ? path : path.substring(i + 1);
    }

    public static String getImplClassName(String path) {
        return PathUtils.getIntfClassName(path) + "Impl";
    }

    public static String getIntfPackageName(String path) {
        int i = path.lastIndexOf(47);
        if (i > 0) {
            return StringUtils.templatePathToClassName(path.substring(0, i));
        }
        return "";
    }

    public static String getImplPackageName(String path) {
        return PathUtils.getIntfPackageName(path);
    }

    public static String getFullyQualifiedIntfClassName(String path) {
        return PathUtils.fullyQualify(PathUtils.getIntfPackageName(path), PathUtils.getIntfClassName(path));
    }

    public static String getFullyQualifiedImplClassName(String path) {
        return PathUtils.fullyQualify(PathUtils.getImplPackageName(path), PathUtils.getImplClassName(path));
    }

    public static String getPathForProxyClass(Class<?> clazz) {
        return clazz.getName().replace(".", "/");
    }

    private static String fullyQualify(String pkgName, String className) {
        return "".equals(pkgName) ? className : pkgName + "." + className;
    }
}

