/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jamon.codegen.AbstractArgument;
import org.jamon.codegen.AbstractSourceGenerator;
import org.jamon.codegen.AnnotationType;
import org.jamon.codegen.ArgNames;
import org.jamon.codegen.ClassNames;
import org.jamon.codegen.CodeWriter;
import org.jamon.codegen.FragmentArgument;
import org.jamon.codegen.FragmentUnit;
import org.jamon.codegen.MethodUnit;
import org.jamon.codegen.OptionalArgument;
import org.jamon.codegen.PathUtils;
import org.jamon.codegen.RequiredArgument;
import org.jamon.codegen.TemplateDescriber;
import org.jamon.codegen.TemplateDescription;
import org.jamon.codegen.TemplateUnit;
import org.jamon.codegen.Unit;
import org.jamon.compiler.ParserErrorImpl;
import org.jamon.compiler.ParserErrorsImpl;
import org.jamon.node.LocationImpl;

public class ProxyGenerator
extends AbstractSourceGenerator {
    public ProxyGenerator(TemplateDescriber describer, TemplateUnit templateUnit) {
        super(describer, templateUnit);
    }

    public void generateSource(OutputStream out) throws IOException {
        this.writer = new CodeWriter(out, this.templateUnit.getEncoding());
        this.generateHeader();
        this.generatePrologue();
        this.generateImports();
        this.generateAnnotations();
        this.generateDeclaration();
        this.generateConstructors();
        this.generateIntf();
        this.generateImplData();
        if (this.templateUnit.getJamonContextType() != null) {
            this.generateJamonContextSetter();
        }
        this.generateOptionalArgs();
        this.generateFragmentInterfaces(false);
        if (this.templateUnit.isReplacing()) {
            this.generateReplacementConstructor();
        }
        if (!this.templateUnit.isParent()) {
            this.generateConstructImplReflective();
            this.generateConstructImplDirect();
            this.generateMakeRenderer();
            this.generateRender();
            this.generateRenderNoFlush();
        }
        if (this.templateUnit.isParent()) {
            this.generateParentRendererClass();
        }
        if (this.templateUnit.hasParentPath() && !this.templateUnit.isParent()) {
            this.generateMakeParentRenderer();
        }
        this.generateEpilogue();
        this.writer.finish();
    }

    private void generateImports() {
        this.templateUnit.printImports(this.writer);
    }

    private String getClassName() {
        return PathUtils.getIntfClassName(this.templateUnit.getName());
    }

    private String getPackageName() {
        return PathUtils.getIntfPackageName(this.templateUnit.getName());
    }

    private void generateHeader() {
        this.writer.println("// Autogenerated Jamon proxy");
        this.writer.println("// " + this.describer.getExternalIdentifier(this.templateUnit.getName()).replace('\\', '/'));
        this.writer.println();
    }

    private void generatePrologue() {
        String pkgName = this.getPackageName();
        if (pkgName.length() > 0) {
            this.writer.println("package " + pkgName + ";");
            this.writer.println();
        }
    }

    private void generateConstructors() {
        this.writer.println();
        this.writer.println("public " + this.getClassName() + "(" + ClassNames.TEMPLATE_MANAGER + " p_manager)");
        this.writer.openBlock();
        this.writer.println(" super(p_manager);");
        this.writer.closeBlock();
        this.writer.println();
        this.writer.println("protected " + this.getClassName() + "(String p_path)");
        this.writer.openBlock();
        this.writer.println("super(p_path);");
        this.writer.closeBlock();
        this.writer.println();
        if (!this.templateUnit.isParent()) {
            this.writer.println("public " + this.getClassName() + "()");
            this.writer.openBlock();
            this.writer.println(" super(\"" + this.templateUnit.getName() + "\");");
            this.writer.closeBlock();
            this.writer.println();
        }
    }

    private void generateFragmentInterfaces(boolean inner) {
        for (FragmentArgument farg : this.templateUnit.getDeclaredFragmentArgs()) {
            farg.getFragmentUnit().printInterface(this.writer, "public", !inner);
            this.writer.println();
        }
        this.writer.println();
    }

    private void generateReplacementConstructor() {
        this.writer.println();
        this.writer.print("public static class ReplacementConstructor implements " + ClassNames.REPLACEMENT_CONSTRUCTOR + " ");
        this.writer.openBlock();
        if (this.templateUnit.getGenericParams().getCount() > 0) {
            this.writer.print("@SuppressWarnings(\"rawtypes\") ");
        }
        this.writer.print("@Override public " + ClassNames.TEMPLATE + " makeReplacement() ");
        this.writer.openBlock();
        this.writer.println("return new " + this.getClassName() + "();");
        this.writer.closeBlock();
        this.writer.closeBlock();
    }

    private void generateAnnotations() {
        if (this.templateUnit.isReplaceable()) {
            this.writer.println("@" + ClassNames.REPLACEABLE);
        }
        if (this.templateUnit.isReplacing()) {
            this.writer.print("@" + ClassNames.REPLACES);
            this.writer.openList("(", true);
            this.writer.printListElement("replacedProxy = " + this.getReplacedProxyClassName() + ".class");
            this.writer.printListElement("replacementConstructor = " + this.getClassName() + ".ReplacementConstructor.class");
            this.writer.closeList();
            this.writer.println();
        }
        this.writer.print("@" + ClassNames.TEMPLATE_ANNOTATION);
        this.writer.openList("(", true);
        this.writer.printListElement("signature = \"" + this.templateUnit.getSignature() + "\"");
        if (this.templateUnit.getGenericParams().getCount() > 0) {
            this.writer.printListElement("genericsCount = " + this.templateUnit.getGenericParams().getCount());
        }
        if (this.templateUnit.getInheritanceDepth() > 0) {
            this.writer.printListElement("inheritanceDepth = " + this.templateUnit.getInheritanceDepth());
        }
        if (this.templateUnit.getJamonContextType() != null) {
            this.writer.printListElement("jamonContextType = \"" + this.templateUnit.getJamonContextType() + "\"");
        }
        if (this.templateUnit.isReplaceable()) {
            this.writer.printListElement("replaceable = true");
        }
        this.generateArguments(this.templateUnit);
        this.generateMethodAnnotations();
        this.generateAbstractMethodAnnotations();
        this.writer.closeList(")");
        this.writer.println();
    }

    private void generateMethodAnnotations() {
        if (!this.templateUnit.getSignatureMethodUnits().isEmpty()) {
            this.writer.printListElement("methods = ");
            this.writer.openList("{", true);
            for (MethodUnit methodUnit : this.templateUnit.getSignatureMethodUnits()) {
                this.writer.printListElement("@" + ClassNames.METHOD_ANNOTATION);
                this.writer.openList("(", true);
                this.writer.printListElement("name = \"" + methodUnit.getName() + "\"");
                this.generateArguments(methodUnit);
                this.writer.closeList(")");
            }
            this.writer.closeList("}");
        }
    }

    private void generateAbstractMethodAnnotations() {
        if (!this.templateUnit.getAbstractMethodNames().isEmpty()) {
            this.writer.printListElement("abstractMethodNames = ");
            this.writer.openList("{", false);
            for (String methodName : this.templateUnit.getAbstractMethodNames()) {
                this.writer.printListElement("\"" + methodName + "\"");
            }
            this.writer.closeList("}");
        }
    }

    private void generateArguments(Unit p_unit) {
        this.generateArgumentAnnotations("requiredArguments", p_unit.getSignatureRequiredArgs());
        this.generateArgumentAnnotations("optionalArguments", p_unit.getSignatureOptionalArgs());
        this.generateFragmentAnnotations(p_unit.getFragmentArgs());
    }

    private void generateFragmentAnnotations(Collection<FragmentArgument> fargs) {
        if (!fargs.isEmpty()) {
            this.writer.printListElement("fragmentArguments = ");
            this.writer.openList("{", true);
            for (FragmentArgument farg : fargs) {
                this.writer.printListElement("@" + ClassNames.FRAGMENT_ANNOTATION);
                this.writer.openList("(", true);
                this.writer.printListElement("name = \"" + farg.getName() + "\"");
                this.generateArgumentAnnotations("requiredArguments", farg.getFragmentUnit().getRequiredArgs());
                this.generateArgumentAnnotations("optionalArguments", farg.getFragmentUnit().getOptionalArgs());
                this.writer.closeList(")");
            }
            this.writer.closeList("}");
        }
    }

    private void generateArgumentAnnotations(String label, Collection<? extends AbstractArgument> args) {
        if (!args.isEmpty()) {
            this.writer.printListElement(label + " = ");
            this.writer.openList("{", true);
            for (AbstractArgument abstractArgument : args) {
                this.writer.printListElement("@" + ClassNames.ARGUMENT_ANNOTATION + "(name = \"" + abstractArgument.getName() + "\", type = \"" + abstractArgument.getType() + "\")");
            }
            this.writer.closeList("}");
        }
    }

    private void generateDeclaration() {
        this.generateCustomAnnotations(this.templateUnit.getAnnotations(), AnnotationType.PROXY);
        this.writer.print("public ");
        if (this.templateUnit.isParent()) {
            this.writer.print("abstract ");
        }
        this.writer.println("class " + this.getClassName() + this.templateUnit.getGenericParams().generateGenericsDeclaration());
        this.writer.println("  extends " + this.templateUnit.getProxyParentClass());
        this.templateUnit.printInterfaces(this.writer);
        this.writer.openBlock();
    }

    private void generateConstructImplReflective() {
        this.writer.println();
        this.writer.println("@Override");
        this.writer.print("public " + ClassNames.BASE_TEMPLATE + " constructImpl" + "(Class<? extends " + ClassNames.BASE_TEMPLATE + "> p_class)");
        this.writer.openBlock();
        this.writer.println("try");
        this.writer.openBlock();
        this.writer.println("return p_class");
        this.writer.indent();
        this.writer.println(".getConstructor(new Class [] { " + ClassNames.TEMPLATE_MANAGER + ".class" + ", ImplData.class })");
        this.writer.println(".newInstance(new Object [] { getTemplateManager(), getImplData()});");
        this.writer.outdent();
        this.writer.closeBlock();
        this.writer.println("catch (RuntimeException e)");
        this.writer.openBlock();
        this.writer.println("throw e;");
        this.writer.closeBlock();
        this.writer.println("catch (Exception e)");
        this.writer.openBlock();
        this.writer.println("throw new RuntimeException(e);");
        this.writer.closeBlock();
        this.writer.closeBlock();
    }

    private void generateConstructImplDirect() {
        this.writer.println();
        this.writer.println("@Override");
        this.writer.print("protected " + ClassNames.BASE_TEMPLATE + " constructImpl()");
        this.writer.openBlock();
        this.writer.println("return new " + PathUtils.getImplClassName(this.templateUnit.getName()) + this.genericParamsList() + "(getTemplateManager(), getImplData());");
        this.writer.closeBlock();
    }

    private void generateRender() {
        this.writer.print((this.templateUnit.isParent() ? "protected" : "public") + " void render");
        this.writer.openList();
        this.writer.printListElement(ArgNames.WRITER_DECL);
        this.templateUnit.printRenderArgsDecl(this.writer);
        this.writer.closeList();
        this.writer.println();
        this.writer.println("  throws " + ClassNames.IOEXCEPTION);
        this.writer.openBlock();
        this.writer.print("renderNoFlush");
        this.writer.openList();
        this.writer.printListElement("jamonWriter");
        this.templateUnit.printRenderArgs(this.writer);
        this.writer.closeList();
        this.writer.println(";");
        this.writer.println("jamonWriter.flush();");
        this.writer.closeBlock();
    }

    private void generateRenderNoFlush() {
        this.writer.print((this.templateUnit.isParent() ? "protected" : "public") + " void renderNoFlush");
        this.writer.openList();
        this.writer.printListElement(ArgNames.WRITER_DECL);
        this.templateUnit.printRenderArgsDecl(this.writer);
        this.writer.closeList();
        this.writer.println();
        this.writer.println("  throws " + ClassNames.IOEXCEPTION);
        this.writer.openBlock();
        if (!this.templateUnit.getRenderArgs().isEmpty()) {
            this.writer.println("ImplData" + this.genericParamsList() + " implData = getImplData();");
            for (AbstractArgument arg : this.templateUnit.getRenderArgs()) {
                this.writer.println("implData." + arg.getSetterName() + "(" + arg.getName() + ");");
            }
        }
        if (this.templateUnit.getGenericParams().getCount() > 0) {
            this.writer.print("@SuppressWarnings(\"unchecked\") ");
        }
        this.writer.print("Intf" + this.genericParamsList() + " instance = (Intf" + this.genericParamsList() + ") getTemplateManager().constructImpl(this");
        if (this.templateUnit.getJamonContextType() != null) {
            this.writer.print(", getImplData().getJamonContext()");
        }
        this.writer.println(");");
        this.writer.println("instance.renderNoFlush(jamonWriter);");
        this.writer.println("reset();");
        this.writer.closeBlock();
        this.writer.println();
    }

    private void generateMakeRenderer() {
        this.writer.print("public " + ClassNames.RENDERER + " makeRenderer");
        this.writer.openList();
        this.templateUnit.printRenderArgsDecl(this.writer);
        this.writer.closeList();
        this.writer.println();
        this.writer.openBlock();
        this.writer.print("return new " + ClassNames.ABSTRACT_RENDERER + "() ");
        this.writer.openBlock();
        this.writer.println("@Override");
        this.writer.println("public void renderTo(" + ArgNames.WRITER_DECL + ")");
        this.writer.println("  throws " + ClassNames.IOEXCEPTION);
        this.writer.openBlock();
        this.writer.print("render");
        this.writer.openList();
        this.writer.printListElement("jamonWriter");
        this.templateUnit.printRenderArgs(this.writer);
        this.writer.closeList();
        this.writer.println(";");
        this.writer.closeBlock();
        this.writer.closeBlock(";");
        this.writer.closeBlock();
        this.writer.println();
    }

    private void generateImplData() throws ParserErrorsImpl {
        this.writer.println("public static class ImplData" + this.templateUnit.getGenericParams().generateGenericsDeclaration());
        this.writer.print("  extends ");
        this.writer.println(this.implDataAncestor());
        if (this.templateUnit.isReplacing()) {
            this.writer.print("  implements ");
            this.writer.print(ClassNames.IMPL_DATA_COMPATIBLE);
            this.writer.println("<" + this.getReplacedImplDataClassName() + ">");
        }
        this.writer.openBlock();
        if (this.templateUnit.isReplacing()) {
            this.generatePopulateFrom();
        }
        if (this.templateUnit.isOriginatingJamonContext()) {
            this.writer.println("private " + this.templateUnit.getJamonContextType() + " m_jamonContext;");
            this.writer.println("public " + this.templateUnit.getJamonContextType() + " getJamonContext()");
            this.writer.openBlock();
            this.writer.println("return m_jamonContext;");
            this.writer.closeBlock();
            this.writer.println("public void setJamonContext(" + this.templateUnit.getJamonContextType() + " p_jamonContext)");
            this.writer.openBlock();
            this.writer.println("m_jamonContext = p_jamonContext;");
            this.writer.closeBlock();
        }
        for (AbstractArgument arg : this.templateUnit.getDeclaredArgs()) {
            arg.generateImplDataCode(this.writer);
        }
        this.writer.closeBlock();
        if (!this.templateUnit.isParent()) {
            this.writer.println("@Override");
            this.writer.println("protected " + ClassNames.TEMPLATE + ".ImplData" + " makeImplData()");
            this.writer.openBlock();
            this.writer.println("return new ImplData" + this.genericParamsList() + "();");
            this.writer.closeBlock();
        }
        if (!this.templateUnit.isParent() || !this.templateUnit.getSignatureOptionalArgs().isEmpty() || this.templateUnit.getJamonContextType() != null) {
            this.generateGetImplData();
        }
    }

    private void generateGetImplData() {
        if (this.templateUnit.getGenericParams().getCount() > 0) {
            this.writer.print("@SuppressWarnings(\"unchecked\") ");
        }
        this.writer.println("@Override public ImplData" + this.genericParamsList() + " getImplData()");
        this.writer.openBlock();
        this.writer.println("return (ImplData" + this.genericParamsList() + ") super.getImplData();");
        this.writer.closeBlock();
    }

    private void generatePopulateFrom() throws ParserErrorsImpl {
        for (FragmentArgument farg : this.templateUnit.getFragmentArgs()) {
            this.generateFragmentDelegator(farg);
        }
        this.writer.print("@Override public void populateFrom(" + this.getReplacedImplDataClassName() + " implData) ");
        this.writer.openBlock();
        TemplateDescription replacedTemplateDescription = this.templateUnit.getReplacedTemplateDescription();
        for (RequiredArgument arg : this.templateUnit.getSignatureRequiredArgs()) {
            this.writer.println(arg.getSetterName() + "(implData." + arg.getGetterName() + "());");
        }
        Set<String> replacedTemplateOptionalArgNames = ProxyGenerator.getOptionalArgNames(replacedTemplateDescription);
        for (OptionalArgument arg : replacedTemplateDescription.getOptionalArgs()) {
            this.writer.printLocation(arg.getLocation());
            if (replacedTemplateOptionalArgNames.contains(arg.getName())) {
                this.writer.println("if(implData." + arg.getIsNotDefaultName() + "()) {");
                this.writer.println("  " + arg.getSetterName() + "(implData." + arg.getGetterName() + "());");
                this.writer.println("}");
                continue;
            }
            this.writer.println(arg.getSetterName() + "(implData." + arg.getGetterName() + "());");
        }
        if (this.templateUnit.getJamonContextType() != null) {
            if (replacedTemplateDescription.getJamonContextType() == null) {
                throw new ParserErrorsImpl(new ParserErrorImpl(this.templateTopLocation(), "Replaced component does not have a jamonContext, but replacing component has a jamonContext of type " + this.templateUnit.getJamonContextType()));
            }
            this.writer.printLocation(this.templateTopLocation());
            this.writer.println("setJamonContext(implData.getJamonContext());");
        }
        for (FragmentArgument farg : this.templateUnit.getFragmentArgs()) {
            this.writer.printLocation(farg.getLocation());
            this.writer.println(farg.getSetterName() + "(new " + this.getFragmentDelegatorName(farg) + this.genericParamsList() + "(implData." + farg.getGetterName() + "()));");
        }
        this.writer.closeBlock();
    }

    private void generateFragmentDelegator(FragmentArgument farg) {
        String fragmentInterfaceName = "Fragment_" + farg.getName() + this.genericParamsList();
        String replacedFragmentInterfaceName = this.getReplacedProxyClassName() + "." + fragmentInterfaceName;
        FragmentUnit fragmentUnit = farg.getFragmentUnit();
        this.writer.print("private static class " + this.getFragmentDelegatorName(farg) + this.templateUnit.getGenericParams().generateGenericsDeclaration() + " implements " + fragmentInterfaceName);
        this.writer.openBlock();
        this.writer.println("private final " + replacedFragmentInterfaceName + " frag;");
        this.writer.println();
        this.writer.print("public " + this.getFragmentDelegatorName(farg) + "(" + replacedFragmentInterfaceName + " frag)");
        this.writer.openBlock();
        this.writer.println("this.frag = frag;");
        this.writer.closeBlock();
        this.writer.println();
        this.writer.print("@Override public void renderNoFlush");
        this.writer.openList();
        this.writer.printListElement(ArgNames.WRITER_DECL);
        fragmentUnit.printRenderArgsDecl(this.writer);
        this.writer.closeList();
        this.writer.println();
        this.writer.println("  throws java.io.IOException");
        this.writer.openBlock();
        this.writer.print("this.frag.renderNoFlush");
        this.writer.openList();
        this.writer.printListElement("jamonWriter");
        fragmentUnit.printRenderArgs(this.writer);
        this.writer.closeList();
        this.writer.println(";");
        this.writer.closeBlock();
        this.writer.print("@Override public " + ClassNames.RENDERER + " makeRenderer");
        this.writer.openList();
        fragmentUnit.printRenderArgsDecl(this.writer);
        this.writer.closeList();
        this.writer.openBlock();
        this.writer.print("return this.frag.makeRenderer");
        this.writer.openList();
        fragmentUnit.printRenderArgs(this.writer);
        this.writer.closeList();
        this.writer.println(";");
        this.writer.closeBlock();
        this.writer.closeBlock();
        this.writer.println();
    }

    private String getFragmentDelegatorName(FragmentArgument farg) {
        return "Fragment_" + farg.getName() + "_Delegator";
    }

    private String getReplacedImplDataClassName() {
        return this.getReplacedProxyClassName() + ".ImplData" + this.genericParamsList();
    }

    private String getReplacedIntfClassName() {
        return this.getReplacedProxyClassName() + ".Intf" + this.genericParamsList();
    }

    private String getReplacedProxyClassName() {
        return PathUtils.getFullyQualifiedIntfClassName(this.templateUnit.getReplacedTemplatePath());
    }

    private static Set<String> getOptionalArgNames(TemplateDescription replacedTemplateDescription) {
        HashSet<String> replacedTemplateOptionalArgNames = new HashSet<String>();
        for (OptionalArgument arg : replacedTemplateDescription.getOptionalArgs()) {
            replacedTemplateOptionalArgNames.add(arg.getName());
        }
        return replacedTemplateOptionalArgNames;
    }

    private String implDataAncestor() {
        return this.templateUnit.hasParentPath() ? PathUtils.getFullyQualifiedIntfClassName(this.templateUnit.getParentPath()) + ".ImplData" : ClassNames.IMPL_DATA;
    }

    private void generateJamonContextSetter() {
        this.writer.println();
        if (!this.templateUnit.isOriginatingJamonContext()) {
            this.writer.print("@Override ");
        }
        this.writer.print("public ");
        this.printFullProxyType();
        this.writer.println(" setJamonContext(" + this.templateUnit.getJamonContextType() + " p_jamonContext)");
        this.writer.openBlock();
        this.writer.println("getImplData().setJamonContext(p_jamonContext);");
        this.writer.println("return this;");
        this.writer.closeBlock();
    }

    private void generateOptionalArgs() {
        for (OptionalArgument arg : this.templateUnit.getDeclaredOptionalArgs()) {
            this.writer.println();
            this.writer.println("protected " + arg.getType() + " " + arg.getName() + ";");
            this.writer.print("public final ");
            this.printFullProxyType();
            this.writer.println(" " + arg.getSetterName() + "(" + arg.getType() + " p_" + arg.getName() + ")");
            this.writer.openBlock();
            this.writer.println("(getImplData())." + arg.getSetterName() + "(p_" + arg.getName() + ");");
            this.writer.println("return this;");
            this.writer.closeBlock();
        }
    }

    private void printFullProxyType() {
        String pkgName = this.getPackageName();
        if (pkgName.length() > 0) {
            this.writer.print(pkgName + ".");
        }
        this.writer.print(this.getClassName());
        this.writer.print(this.genericParamsList());
    }

    private void generateIntf() {
        this.writer.println("public interface Intf" + this.templateUnit.getGenericParams().generateGenericsDeclaration());
        this.writer.print("  extends ");
        this.writer.openList("", false);
        if (this.templateUnit.hasParentPath()) {
            this.writer.printListElement(PathUtils.getFullyQualifiedIntfClassName(this.templateUnit.getParentPath()) + ".Intf");
        }
        if (this.templateUnit.isReplacing()) {
            this.writer.printListElement(this.getReplacedIntfClassName());
        }
        if (!this.templateUnit.hasParentPath() && !this.templateUnit.isReplacing()) {
            this.writer.printListElement(ClassNames.TEMPLATE_INTF);
        }
        this.writer.closeList("");
        this.writer.println();
        this.writer.openBlock();
        this.generateFragmentInterfaces(true);
        if (!this.templateUnit.isParent()) {
            if (this.templateUnit.isReplacing()) {
                this.writer.print("@Override ");
            }
            this.writer.println("void renderNoFlush(" + ArgNames.WRITER_DECL + ") throws " + ClassNames.IOEXCEPTION + ";");
            this.writer.println();
        }
        this.writer.closeBlock();
    }

    private void generateParentRendererClass() {
        this.writer.println("public abstract class ParentRenderer");
        this.writer.openBlock();
        this.writer.println("protected ParentRenderer() {}");
        for (OptionalArgument arg : this.templateUnit.getSignatureOptionalArgs()) {
            this.writer.println();
            String name = arg.getName();
            this.writer.print("public final ParentRenderer ");
            this.writer.println(arg.getSetterName() + "(" + arg.getType() + " p_" + name + ")");
            this.writer.openBlock();
            this.writer.println(this.getClassName() + ".this." + arg.getSetterName() + "(" + "p_" + name + ");");
            this.writer.println("return this;");
            this.writer.closeBlock();
        }
        if (this.templateUnit.getJamonContextType() != null) {
            this.writer.print("public final ParentRenderer setJamonContext(" + this.templateUnit.getJamonContextType() + " p_jamonContext)");
            this.writer.openBlock();
            this.writer.println(this.getClassName() + ".this.setJamonContext(p_jamonContext);");
            this.writer.println("return this;");
            this.writer.closeBlock();
        }
        if (!this.templateUnit.hasParentPath()) {
            this.writer.print("public void render");
            this.writer.openList();
            this.writer.printListElement(ArgNames.WRITER_DECL);
            this.templateUnit.printDeclaredRenderArgsDecl(this.writer);
            this.writer.closeList();
            this.writer.println();
            this.writer.print("  throws " + ClassNames.IOEXCEPTION);
            this.writer.openBlock();
            this.writer.print("renderNoFlush");
            this.writer.openList();
            this.writer.printListElement("jamonWriter");
            this.templateUnit.printDeclaredRenderArgs(this.writer);
            this.writer.closeList();
            this.writer.println(";");
            this.writer.println("jamonWriter.flush();");
            this.writer.closeBlock();
            this.writer.print("public void renderNoFlush");
            this.writer.openList();
            this.writer.printListElement(ArgNames.WRITER_DECL);
            this.templateUnit.printDeclaredRenderArgsDecl(this.writer);
            this.writer.closeList();
            this.writer.println();
            this.writer.print("  throws " + ClassNames.IOEXCEPTION);
            this.writer.openBlock();
            this.writer.print("renderChild");
            this.writer.openList();
            this.writer.printListElement("jamonWriter");
            this.templateUnit.printDeclaredRenderArgs(this.writer);
            this.writer.closeList();
            this.writer.println(";");
            this.writer.closeBlock();
            this.generateMakeRenderer();
        } else {
            this.generateMakeParentRenderer();
        }
        this.writer.print("protected abstract void renderChild");
        this.writer.openList();
        this.writer.printListElement(ArgNames.WRITER_DECL);
        this.templateUnit.printRenderArgsDecl(this.writer);
        this.writer.closeList();
        this.writer.println();
        this.writer.println("  throws " + ClassNames.IOEXCEPTION + ";");
        this.writer.closeBlock();
    }

    private void generateMakeParentRenderer() {
        String parentRendererClass = PathUtils.getFullyQualifiedIntfClassName(this.templateUnit.getParentPath()) + ".ParentRenderer";
        this.writer.print("public " + parentRendererClass + " makeParentRenderer");
        this.writer.openList();
        this.templateUnit.printDeclaredRenderArgsDecl(this.writer);
        this.writer.closeList();
        this.writer.println();
        this.writer.openBlock();
        this.writer.print("return new " + parentRendererClass + "() ");
        this.writer.openBlock();
        this.writer.print("@Override protected void renderChild");
        this.writer.openList();
        this.writer.printListElement(ArgNames.WRITER_DECL);
        this.templateUnit.printParentRenderArgsDecl(this.writer);
        this.writer.closeList();
        this.writer.println();
        this.writer.println("  throws " + ClassNames.IOEXCEPTION);
        this.writer.openBlock();
        this.writer.print(PathUtils.getFullyQualifiedIntfClassName(this.getClassName()));
        if (this.templateUnit.isParent()) {
            this.writer.print(".ParentRenderer.this.renderChild");
        } else {
            this.writer.print(".this.renderNoFlush");
        }
        this.writer.openList();
        this.writer.printListElement("jamonWriter");
        this.templateUnit.printRenderArgs(this.writer);
        this.writer.closeList();
        this.writer.println(";");
        this.writer.closeBlock();
        this.writer.closeBlock(";");
        this.writer.closeBlock();
    }

    private void generateEpilogue() {
        this.writer.println();
        this.writer.closeBlock();
    }

    private String genericParamsList() {
        return this.templateUnit.getGenericParams().generateGenericParamsList();
    }

    private LocationImpl templateTopLocation() {
        return new LocationImpl(this.describer.getTemplateLocation(this.templateUnit.getName()), 1, 1);
    }
}

