/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.jamon.api.Location;
import org.jamon.api.TemplateLocation;
import org.jamon.api.TemplateSource;
import org.jamon.codegen.Analyzer;
import org.jamon.codegen.EncodingReader;
import org.jamon.codegen.EscapingDirective;
import org.jamon.codegen.TemplateDescription;
import org.jamon.compiler.ParserErrorImpl;
import org.jamon.compiler.ParserErrorsImpl;
import org.jamon.emit.EmitMode;
import org.jamon.node.LocationImpl;
import org.jamon.node.TopNode;
import org.jamon.parser.TopLevelParser;
import org.jamon.util.StringUtils;

public class TemplateDescriber {
    private static final String JAMON_CONTEXT_TYPE_KEY = "org.jamon.contextType";
    private static final String EMIT_MODE_KEY = "org.jamon.emitMode";
    private static final String ESCAPING_KEY = "org.jamon.escape";
    private final Map<String, TemplateDescription> m_descriptionCache = new HashMap<String, TemplateDescription>();
    private final TemplateSource templateSource;
    private final ClassLoader classLoader;
    private static final String ALIAS_PROPERTY_PREFIX = "org.jamon.alias.";

    public TemplateDescriber(TemplateSource templateSource, ClassLoader classLoader) {
        this.templateSource = templateSource;
        this.classLoader = classLoader;
    }

    public TemplateDescription getTemplateDescription(String path, Location location) throws IOException, ParserErrorImpl {
        return this.getTemplateDescription(path, location, new HashSet<String>());
    }

    public TemplateDescription getTemplateDescription(String path, Location location, Set<String> children) throws IOException, ParserErrorImpl {
        if (this.m_descriptionCache.containsKey(path)) {
            return this.m_descriptionCache.get(path);
        }
        TemplateDescription desc = this.computeTemplateDescription(path, location, children);
        this.m_descriptionCache.put(path, desc);
        return desc;
    }

    private TemplateDescription computeTemplateDescription(String path, Location location, Set<String> children) throws IOException, ParserErrorImpl {
        if (this.templateSource.available(path)) {
            return new TemplateDescription(new Analyzer(path, this, children).analyze());
        }
        try {
            return new TemplateDescription(this.classLoader.loadClass(StringUtils.templatePathToClassName(path)));
        }
        catch (ClassNotFoundException e) {
            throw new ParserErrorImpl(location, "Unable to find template or class for " + path);
        }
        catch (NoSuchFieldException e) {
            throw new ParserErrorImpl(location, "Malformed class for " + path);
        }
    }

    public TopNode parseTemplate(String path) throws IOException {
        InputStream stream = this.templateSource.getStreamFor(path);
        try {
            EncodingReader reader = new EncodingReader(stream);
            TopNode topNode = new TopLevelParser(this.templateSource.getTemplateLocation(path), reader, reader.getEncoding()).parse().getRootNode();
            return topNode;
        }
        catch (EncodingReader.Exception e) {
            throw new ParserErrorsImpl(new ParserErrorImpl(new LocationImpl(this.templateSource.getTemplateLocation(path), 1, e.getPos()), e.getMessage()));
        }
        catch (ParserErrorsImpl e) {
            throw e;
        }
        finally {
            stream.close();
        }
    }

    public TemplateLocation getTemplateLocation(String path) {
        return this.templateSource.getTemplateLocation(path);
    }

    public String getExternalIdentifier(String path) {
        return this.templateSource.getExternalIdentifier(path);
    }

    private Properties getProperties(String path) throws IOException {
        StringTokenizer tokenizer = new StringTokenizer(path, "/");
        StringBuffer partialPath = new StringBuffer("/");
        Properties properties = new Properties();
        while (tokenizer.hasMoreTokens()) {
            this.templateSource.loadProperties(partialPath.toString(), properties);
            String nextComponent = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) continue;
            partialPath.append(nextComponent);
            partialPath.append("/");
        }
        return properties;
    }

    public Map<String, String> getAliases(String path) throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        Properties props = this.getProperties(path);
        for (Object okey : props.keySet()) {
            String key = (String)okey;
            if (!key.startsWith(ALIAS_PROPERTY_PREFIX)) continue;
            String aliasName = key.substring(ALIAS_PROPERTY_PREFIX.length());
            String alias = props.getProperty(key);
            if (alias == null || alias.trim().length() == 0) {
                result.remove(aliasName);
                continue;
            }
            result.put(aliasName, props.getProperty(key));
        }
        return result;
    }

    public String getJamonContextType(String path) throws IOException {
        String contextType = this.getProperties(path).getProperty(JAMON_CONTEXT_TYPE_KEY, "").trim();
        return contextType.length() > 0 ? contextType : null;
    }

    public EmitMode getEmitMode(String path) throws IOException {
        String emitModeName = this.getProperties(path).getProperty(EMIT_MODE_KEY);
        if (emitModeName != null) {
            EmitMode emitMode = EmitMode.fromString((String)emitModeName);
            if (emitMode == null) {
                throw new RuntimeException("Unknown emit mode: " + emitModeName);
            }
            return emitMode;
        }
        return EmitMode.STANDARD;
    }

    public EscapingDirective getEscaping(String path) throws IOException {
        return EscapingDirective.get(this.getProperties(path).getProperty(ESCAPING_KEY));
    }
}

