/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jamon.annotations.Argument;
import org.jamon.annotations.Fragment;
import org.jamon.annotations.Method;
import org.jamon.annotations.Template;
import org.jamon.codegen.DeclaredMethodUnit;
import org.jamon.codegen.FragmentArgument;
import org.jamon.codegen.FragmentUnit;
import org.jamon.codegen.GenericParams;
import org.jamon.codegen.MethodUnit;
import org.jamon.codegen.OptionalArgument;
import org.jamon.codegen.PathUtils;
import org.jamon.codegen.RequiredArgument;
import org.jamon.codegen.TemplateUnit;
import org.jamon.codegen.Unit;
import org.jamon.util.AnnotationReflector;

public class TemplateDescription {
    private final List<RequiredArgument> requiredArgs;
    private final Set<OptionalArgument> optionalArgs;
    private final String signature;
    private final List<FragmentArgument> fragmentInterfaces;
    private final Map<String, MethodUnit> methodUnits;
    private final int inheritanceDepth;
    private final Collection<String> abstractMethodNames;
    private final int genericParamsCount;
    private final String jamonContextType;
    private final boolean replaceable;
    public static final TemplateDescription EMPTY = new TemplateDescription();

    private TemplateDescription() {
        this.requiredArgs = Collections.emptyList();
        this.optionalArgs = Collections.emptySet();
        this.signature = null;
        this.fragmentInterfaces = Collections.emptyList();
        this.methodUnits = Collections.emptyMap();
        this.inheritanceDepth = -1;
        this.abstractMethodNames = Collections.emptyList();
        this.genericParamsCount = 0;
        this.jamonContextType = null;
        this.replaceable = false;
    }

    public TemplateDescription(TemplateUnit templateUnit) {
        this.requiredArgs = new LinkedList<RequiredArgument>();
        this.requiredArgs.addAll(templateUnit.getSignatureRequiredArgs());
        this.optionalArgs = new TreeSet<OptionalArgument>();
        this.optionalArgs.addAll(templateUnit.getSignatureOptionalArgs());
        for (OptionalArgument arg : this.optionalArgs) {
            arg.setDefault(null);
        }
        this.signature = templateUnit.getSignature();
        this.fragmentInterfaces = templateUnit.getFragmentArgs();
        this.methodUnits = new TreeMap<String, MethodUnit>();
        for (MethodUnit methodUnit : templateUnit.getSignatureMethodUnits()) {
            this.methodUnits.put(methodUnit.getName(), methodUnit);
        }
        this.inheritanceDepth = templateUnit.getInheritanceDepth();
        this.abstractMethodNames = templateUnit.getAbstractMethodNames();
        this.genericParamsCount = templateUnit.getGenericParams().getCount();
        this.jamonContextType = templateUnit.getJamonContextType();
        this.replaceable = templateUnit.isReplaceable();
    }

    public TemplateDescription(Class<?> proxy) throws NoSuchFieldException {
        Template templateAnnotation = new AnnotationReflector(proxy).getAnnotation(Template.class);
        if (templateAnnotation == null) {
            throw new NoSuchFieldException("class " + proxy.getName() + " lacks a template annotation");
        }
        this.requiredArgs = TemplateDescription.getRequiredArgs(templateAnnotation.requiredArguments());
        this.optionalArgs = TemplateDescription.getOptionalArgs(templateAnnotation.optionalArguments());
        this.fragmentInterfaces = TemplateDescription.getFragmentArguments(templateAnnotation.fragmentArguments(), new TemplateUnit(PathUtils.getPathForProxyClass(proxy), null));
        this.methodUnits = new TreeMap<String, MethodUnit>();
        for (Method methodAnnotation : templateAnnotation.methods()) {
            DeclaredMethodUnit method = new DeclaredMethodUnit(methodAnnotation.name(), null, null, null);
            for (Argument argument : methodAnnotation.requiredArguments()) {
                method.addRequiredArg(TemplateDescription.makeRequiredArg(argument));
            }
            for (Argument argument : methodAnnotation.optionalArguments()) {
                method.addOptionalArg(TemplateDescription.makeOptionalArg(argument));
            }
            for (Argument argument : methodAnnotation.fragmentArguments()) {
                method.addFragmentArg(TemplateDescription.makeFragmentArg(method, (Fragment)argument));
            }
            this.methodUnits.put(method.getName(), method);
        }
        this.abstractMethodNames = Arrays.asList(templateAnnotation.abstractMethodNames());
        this.signature = templateAnnotation.signature();
        this.inheritanceDepth = templateAnnotation.inheritanceDepth();
        this.genericParamsCount = templateAnnotation.genericsCount();
        this.jamonContextType = this.nullToEmptyString(templateAnnotation.jamonContextType());
        this.replaceable = templateAnnotation.replaceable();
    }

    private String nullToEmptyString(String jamonContextType) {
        return jamonContextType.equals("") ? null : jamonContextType;
    }

    private static List<RequiredArgument> getRequiredArgs(Argument[] arguments) {
        ArrayList<RequiredArgument> args = new ArrayList<RequiredArgument>(arguments.length);
        for (Argument argument : arguments) {
            args.add(TemplateDescription.makeRequiredArg(argument));
        }
        return args;
    }

    private static Set<OptionalArgument> getOptionalArgs(Argument[] arguments) {
        TreeSet<OptionalArgument> args = new TreeSet<OptionalArgument>();
        for (Argument argument : arguments) {
            args.add(TemplateDescription.makeOptionalArg(argument));
        }
        return args;
    }

    private static RequiredArgument makeRequiredArg(Argument argument) {
        return new RequiredArgument(argument.name(), argument.type(), null);
    }

    private static OptionalArgument makeOptionalArg(Argument argument) {
        return new OptionalArgument(argument.name(), argument.type(), null);
    }

    private static List<FragmentArgument> getFragmentArguments(Fragment[] fragments, Unit parentUnit) {
        ArrayList<FragmentArgument> fragmentArguments = new ArrayList<FragmentArgument>(fragments.length);
        for (Fragment fragment : fragments) {
            fragmentArguments.add(TemplateDescription.makeFragmentArg(parentUnit, fragment));
        }
        return fragmentArguments;
    }

    private static FragmentArgument makeFragmentArg(Unit parentUnit, Fragment fragment) {
        FragmentUnit fragmentUnit = new FragmentUnit(fragment.name(), parentUnit, new GenericParams(), null, null);
        for (Argument argument : fragment.requiredArguments()) {
            fragmentUnit.addRequiredArg(TemplateDescription.makeRequiredArg(argument));
        }
        FragmentArgument fragmentArgument = new FragmentArgument(fragmentUnit, null);
        return fragmentArgument;
    }

    public List<RequiredArgument> getRequiredArgs() {
        return this.requiredArgs;
    }

    public Set<OptionalArgument> getOptionalArgs() {
        return this.optionalArgs;
    }

    public String getSignature() {
        return this.signature;
    }

    public List<FragmentArgument> getFragmentInterfaces() {
        return this.fragmentInterfaces;
    }

    public Map<String, MethodUnit> getMethodUnits() {
        return this.methodUnits;
    }

    public Collection<String> getAbstractMethodNames() {
        return this.abstractMethodNames;
    }

    public int getInheritanceDepth() {
        return this.inheritanceDepth;
    }

    public int getGenericParamsCount() {
        return this.genericParamsCount;
    }

    public String getJamonContextType() {
        return this.jamonContextType;
    }

    public boolean isReplaceable() {
        return this.replaceable;
    }
}

