/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.compiler;

import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import org.jamon.TemplateManager;
import org.jamon.compiler.JamonException;
import org.jamon.compiler.RecompilingTemplateManager;
import org.jamon.compiler.TemplateInspector;

public class InvokerTool {
    private final ObjectParser objectParser;

    public InvokerTool(ObjectParser objectParser) {
        this.objectParser = objectParser;
    }

    public InvokerTool() {
        this(new DefaultObjectParser());
    }

    private void parseArgString(TemplateInspector inspector, Map<String, Object> argMap, String arg) throws UsageException, TemplateArgumentException {
        int i = arg.indexOf("=");
        if (i <= 0) {
            throw new UsageException();
        }
        String name = arg.substring(0, i);
        argMap.put(name, this.objectParser.parseObject(inspector.getArgumentType(name), arg.substring(i + 1)));
    }

    protected void invoke(String[] args) throws UsageException, IOException, TemplateArgumentException, TemplateInspector.UnknownArgumentsException, TemplateInspector.InvalidTemplateException {
        int a;
        RecompilingTemplateManager.Data data = new RecompilingTemplateManager.Data();
        String outFile = null;
        for (a = 0; a < args.length && args[a].startsWith("-"); ++a) {
            if (args[a].startsWith("--workdir=")) {
                data.setWorkDir(args[a].substring(10));
                continue;
            }
            if (args[a].equals("-w")) {
                if (++a < args.length) {
                    data.setWorkDir(args[a]);
                    continue;
                }
                throw new UsageException();
            }
            if (args[a].startsWith("--srcdir=")) {
                data.setSourceDir(args[a].substring(9));
                continue;
            }
            if (args[a].equals("-s")) {
                if (++a < args.length) {
                    data.setSourceDir(args[a]);
                    continue;
                }
                throw new UsageException();
            }
            if (args[a].startsWith("--output=")) {
                outFile = args[a].substring(9);
                continue;
            }
            if (args[a].equals("-o")) {
                if (++a < args.length) {
                    outFile = args[a];
                    continue;
                }
                throw new UsageException();
            }
            throw new UsageException();
        }
        if (a >= args.length) {
            throw new UsageException();
        }
        String templateName = args[a++];
        TemplateInspector inspector = new TemplateInspector((TemplateManager)new RecompilingTemplateManager(data), templateName);
        HashMap<String, Object> argMap = new HashMap<String, Object>();
        while (a < args.length) {
            this.parseArgString(inspector, argMap, args[a++]);
        }
        OutputStreamWriter writer = outFile == null ? new OutputStreamWriter(System.out) : new FileWriter(outFile);
        inspector.render(writer, argMap);
    }

    public static void main(String[] args) throws Exception {
        try {
            new InvokerTool().invoke(args);
        }
        catch (UsageException e) {
            System.err.println("Usage: " + e);
        }
    }

    public static class UsageException
    extends Exception {
        private static final long serialVersionUID = 2006091701L;

        @Override
        public String toString() {
            return "java " + InvokerTool.class.getName() + " [-o outputfile] " + " [-s templatesourcedir]" + " [-w workdir]" + " template-path [[arg1=val1] ...]";
        }
    }

    public static class TemplateArgumentException
    extends JamonException {
        private static final long serialVersionUID = 2006091701L;

        public TemplateArgumentException(Throwable t) {
            super(t);
        }

        public TemplateArgumentException(String msg) {
            super(msg);
        }
    }

    public static class DefaultObjectParser
    implements ObjectParser {
        @Override
        public Object parseObject(Class<?> type, String string) throws TemplateArgumentException {
            try {
                if (string == null) {
                    if (type.isPrimitive()) {
                        throw new TemplateArgumentException("primitive types cannot be null");
                    }
                    return null;
                }
                if (type == String.class) {
                    return string;
                }
                if (type == Boolean.class || type == Boolean.TYPE) {
                    return Boolean.valueOf(string);
                }
                if (type == Integer.class || type == Integer.TYPE) {
                    return Integer.valueOf(string);
                }
                if (type == Float.class || type == Float.TYPE) {
                    return Float.valueOf(string);
                }
                if (type == Double.class || type == Double.TYPE) {
                    return Double.valueOf(string);
                }
                if (type == Short.class || type == Short.TYPE) {
                    return Short.valueOf(string);
                }
                if (type == Byte.class || type == Byte.TYPE) {
                    return Byte.valueOf(string);
                }
                return type.getConstructor(String.class).newInstance(string);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TemplateArgumentException(e);
            }
        }
    }

    public static interface ObjectParser {
        public Object parseObject(Class<?> var1, String var2) throws TemplateArgumentException;
    }
}

