/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.compiler;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import org.jamon.AbstractTemplateImpl;
import org.jamon.AbstractTemplateManager;
import org.jamon.AbstractTemplateProxy;
import org.jamon.IdentityTemplateReplacer;
import org.jamon.TemplateManager;
import org.jamon.TemplateReplacer;
import org.jamon.annotations.Template;
import org.jamon.api.SourceGenerator;
import org.jamon.api.TemplateSource;
import org.jamon.codegen.Analyzer;
import org.jamon.codegen.ImplGenerator;
import org.jamon.codegen.ProxyGenerator;
import org.jamon.codegen.TemplateDescriber;
import org.jamon.codegen.TemplateUnit;
import org.jamon.compiler.FileTemplateSource;
import org.jamon.compiler.TemplateCompilationException;
import org.jamon.util.JavaCompiler;
import org.jamon.util.JavaCompilerFactory;
import org.jamon.util.StringUtils;
import org.jamon.util.WorkDirClassLoader;

public class RecompilingTemplateManager
extends AbstractTemplateManager {
    private final TemplateSource templateSource;
    private final String workDir;
    private final ClassLoader classLoader;
    private final JavaCompiler javaCompiler;
    private final WorkDirClassLoader loader;
    private Map<String, DependencyEntry> dependencyCache = new HashMap<String, DependencyEntry>();
    public static final boolean TRACE = Boolean.valueOf(System.getProperty(RecompilingTemplateManager.class.getName() + ".trace"));

    public RecompilingTemplateManager() {
        this(new Data());
    }

    public RecompilingTemplateManager(Data data) {
        super((TemplateReplacer)(data.getTemplateReplacer() == null ? IdentityTemplateReplacer.INSTANCE : data.getTemplateReplacer()));
        this.classLoader = data.classLoader == null ? ((Object)((Object)this)).getClass().getClassLoader() : data.classLoader;
        this.workDir = data.workDir == null ? RecompilingTemplateManager.getDefaultWorkDir() : data.workDir;
        this.javaCompiler = JavaCompilerFactory.makeCompiler(data, this.workDir, this.classLoader);
        if (TRACE) {
            RecompilingTemplateManager.trace("Java Compiler: " + this.javaCompiler.getClass().getSimpleName());
        }
        this.templateSource = data.templateSource != null ? data.templateSource : new FileTemplateSource(data.sourceDir == null ? System.getProperty("user.dir") : data.sourceDir);
        this.loader = AccessController.doPrivileged(new PrivilegedAction<WorkDirClassLoader>(){

            @Override
            public WorkDirClassLoader run() {
                return new WorkDirClassLoader(RecompilingTemplateManager.this.classLoader, RecompilingTemplateManager.this.workDir);
            }
        });
    }

    protected AbstractTemplateProxy.Intf constructImplFromReplacedProxy(AbstractTemplateProxy replacedProxy) {
        return replacedProxy.constructImpl(this.getImplClass(replacedProxy.getClass()));
    }

    public AbstractTemplateProxy constructProxy(String path) {
        try {
            return this.getProxyClass(path).getConstructor(TemplateManager.class).newInstance(new Object[]{this});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void trace(String p_message) {
        System.err.println(p_message);
    }

    private static String getDefaultWorkDir() {
        File workDir = new File(System.getProperty("java.io.tmpdir"), "jamon" + new Random().nextInt(100000000) + ".tmp");
        if (!workDir.mkdirs()) {
            throw new RuntimeException("Unable to create default work directory " + workDir);
        }
        workDir.deleteOnExit();
        return workDir.toString();
    }

    private Class<? extends AbstractTemplateImpl> getImplClass(Class<? extends AbstractTemplateProxy> proxyClass) {
        return this.getTemplateClass(StringUtils.classToTemplatePath(proxyClass), proxyClass.getName() + "Impl").asSubclass(AbstractTemplateImpl.class);
    }

    private Class<? extends AbstractTemplateProxy> getProxyClass(String path) {
        return this.getTemplateClass(path, StringUtils.templatePathToClassName(path)).asSubclass(AbstractTemplateProxy.class);
    }

    private Class<?> getTemplateClass(String path, String className) {
        try {
            try {
                this.ensureUpToDate(path, new TemplateDescriber(this.templateSource, this.loader));
                return this.loader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                if (!this.templateSource.available(path)) {
                    throw new RuntimeException("The template at path " + path + " could not be found");
                }
                throw new RuntimeException(e);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String prefix() {
        return this.workDir;
    }

    private String javaImpl(String path) {
        return this.prefix() + path + "Impl.java";
    }

    private String classImpl(String path) {
        return this.prefix() + path + "Impl.class";
    }

    private String javaIntf(String p_path) {
        return this.prefix() + p_path + ".java";
    }

    private synchronized void ensureUpToDate(String startingPath, TemplateDescriber describer) throws IOException {
        HashSet<String> seen = new HashSet<String>();
        HashSet<String> outOfDateJavaFiles = new HashSet<String>();
        LinkedList<String> workQueue = new LinkedList<String>();
        workQueue.add(startingPath);
        while (!workQueue.isEmpty()) {
            DependencyEntry d;
            String path = (String)workQueue.remove(0);
            if (TRACE) {
                RecompilingTemplateManager.trace("processing " + path);
            }
            seen.add(path);
            if (!this.templateSource.available(path)) {
                if (!TRACE) continue;
                RecompilingTemplateManager.trace(path + " source not found; assume class exists");
                continue;
            }
            boolean intfGenerated = false;
            long modTime = this.templateSource.lastModified(path);
            String intfFileName = this.javaIntf(path);
            File intfFile = new File(intfFileName);
            if (intfFile.lastModified() < modTime) {
                TemplateUnit templateUnit = new Analyzer(path, describer).analyze();
                String signature = templateUnit.getSignature();
                if (this.isIntfChanged(path, signature, this.classLoader)) {
                    if (this.isIntfChanged(path, signature, this.loader)) {
                        this.generateIntf(path, describer, templateUnit);
                        outOfDateJavaFiles.add(intfFileName);
                        intfGenerated = true;
                    }
                } else {
                    intfFile.delete();
                    this.deleteClassFilesFor(path);
                }
            }
            File jm = new File(this.javaImpl(path));
            long ts = jm.lastModified();
            if (jm.lastModified() < modTime) {
                this.dependencyCache.put(path, new DependencyEntry(this.generateImpl(path, describer)));
                ts = System.currentTimeMillis();
            }
            if (new File(this.classImpl(path)).lastModified() < ts || intfGenerated) {
                outOfDateJavaFiles.add(this.javaImpl(path));
            }
            if ((d = this.dependencyCache.get(path)) == null || d.lastUpdated() < modTime) {
                d = new DependencyEntry(this.computeDependencies(path, describer));
                this.dependencyCache.put(path, d);
            }
            for (String dp : d.getDependencies()) {
                if (seen.contains(dp)) continue;
                workQueue.add(dp);
            }
        }
        if (!outOfDateJavaFiles.isEmpty()) {
            String errors = this.compile(outOfDateJavaFiles);
            this.loader.invalidate();
            if (errors != null) {
                throw new TemplateCompilationException(errors);
            }
        }
    }

    private void deleteClassFilesFor(String path) {
        int i = path.lastIndexOf(47);
        String templateName = i < 0 ? path : path.substring(i + 1);
        File dir = new File(new File(this.workDir), StringUtils.templatePathToFileDir(path));
        String[] files = dir.list();
        if (files != null) {
            for (int j = 0; j < files.length; ++j) {
                if (!StringUtils.isGeneratedClassFilename(templateName, files[j])) continue;
                new File(dir, files[j]).delete();
            }
        }
    }

    private File getWriteableFile(String filename) {
        File file = new File(filename);
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        return file;
    }

    private void generateSource(String filename, SourceGenerator sourceGenerator) throws IOException {
        File javaFile = this.getWriteableFile(filename);
        FileOutputStream out = new FileOutputStream(javaFile);
        try {
            sourceGenerator.generateSource((OutputStream)out);
            out.close();
        }
        catch (IOException e) {
            out.close();
            javaFile.delete();
            throw e;
        }
    }

    private Collection<String> generateImpl(String path, TemplateDescriber describer) throws IOException {
        if (TRACE) {
            RecompilingTemplateManager.trace("generating impl for " + path);
        }
        TemplateUnit templateUnit = new Analyzer(path, describer).analyze();
        this.generateSource(this.javaImpl(path), new ImplGenerator(describer, templateUnit));
        return templateUnit.getTemplateDependencies();
    }

    private void generateIntf(String path, TemplateDescriber describer, TemplateUnit templateUnit) throws IOException {
        if (TRACE) {
            RecompilingTemplateManager.trace("generating intf for " + path);
        }
        this.generateSource(this.javaIntf(path), new ProxyGenerator(describer, templateUnit));
    }

    private String getIntfSignatureFromClass(String path, ClassLoader loader) {
        if (TRACE) {
            RecompilingTemplateManager.trace("Looking for signature of " + StringUtils.templatePathToClassName(path));
        }
        try {
            return loader.loadClass(StringUtils.templatePathToClassName(path)).getAnnotation(Template.class).signature();
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private boolean isIntfChanged(String path, String signature, ClassLoader loader) {
        return !signature.equals(this.getIntfSignatureFromClass(path, loader));
    }

    private String compile(Collection<String> sourceFiles) {
        if (sourceFiles.isEmpty()) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("compiling: ");
        StringUtils.commaJoin(buf, sourceFiles);
        if (TRACE) {
            RecompilingTemplateManager.trace(buf.toString());
        }
        return this.javaCompiler.compile(sourceFiles.toArray(new String[sourceFiles.size()]));
    }

    private Collection<String> computeDependencies(String path, TemplateDescriber describer) throws IOException {
        if (TRACE) {
            RecompilingTemplateManager.trace("computing dependencies for " + path);
        }
        return new Analyzer(path, describer).analyze().getTemplateDependencies();
    }

    private static class DependencyEntry {
        Collection<String> dependencies;
        long lastUpdated;

        DependencyEntry(Collection<String> dependencies) {
            this.dependencies = dependencies;
            this.lastUpdated = System.currentTimeMillis();
        }

        Collection<String> getDependencies() {
            return this.dependencies;
        }

        long lastUpdated() {
            return this.lastUpdated;
        }
    }

    public static class Data {
        private String sourceDir;
        private TemplateSource templateSource;
        private String workDir;
        private String javaCompiler;
        private String classpath;
        private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        private TemplateReplacer templateReplacer;

        public Data setSourceDir(String sourceDir) {
            this.sourceDir = sourceDir;
            return this;
        }

        public String getSourceDir() {
            return this.sourceDir;
        }

        public Data setTemplateSource(TemplateSource templateSource) {
            this.templateSource = templateSource;
            return this;
        }

        public TemplateSource getTemplateSource() {
            return this.templateSource;
        }

        public Data setWorkDir(String workDir) {
            this.workDir = workDir;
            return this;
        }

        public String getWorkDir() {
            return this.workDir;
        }

        public Data setJavaCompiler(String javaCompiler) {
            this.javaCompiler = javaCompiler;
            return this;
        }

        public String getJavaCompiler() {
            return this.javaCompiler;
        }

        public Data setClasspath(String classpath) {
            this.classpath = classpath;
            return this;
        }

        public String getClasspath() {
            return this.classpath;
        }

        public Data setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public Data setTemplateReplacer(TemplateReplacer templateReplacer) {
            this.templateReplacer = templateReplacer;
            return this;
        }

        public TemplateReplacer getTemplateReplacer() {
            return this.templateReplacer;
        }
    }
}

