/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import org.jamon.api.TemplateLocation;
import org.jamon.api.TemplateSource;
import org.jamon.compiler.TemplateResourceLocation;

public class ResourceTemplateSource
implements TemplateSource {
    private final ClassLoader classLoader;
    private final String templateSourceDir;
    private final String extension;

    public ResourceTemplateSource(ClassLoader classLoader, String templateSourceDir) {
        this(classLoader, templateSourceDir, "jamon");
    }

    public ResourceTemplateSource(ClassLoader classLoader, String templateSourceDir, String extension) {
        this.classLoader = classLoader;
        this.templateSourceDir = templateSourceDir;
        this.extension = extension == null || extension.length() == 0 ? "" : "." + extension;
    }

    public long lastModified(String templatePath) throws IOException {
        return this.getTemplate(templatePath).getLastModified();
    }

    public boolean available(String templatePath) {
        return this.getUrl(templatePath) != null;
    }

    public InputStream getStreamFor(String templatePath) throws IOException {
        return this.getTemplate(templatePath).getInputStream();
    }

    public String getExternalIdentifier(String templatePath) {
        return templatePath;
    }

    private URL getUrl(String templatePath) {
        return this.classLoader.getResource(this.resourceName(templatePath));
    }

    private String resourceName(String templatePath) {
        return this.templateSourceDir + templatePath + this.extension;
    }

    private URLConnection getTemplate(String templatePath) throws IOException {
        return this.getUrl(templatePath).openConnection();
    }

    public TemplateLocation getTemplateLocation(String templatePath) {
        return new TemplateResourceLocation(this.resourceName(templatePath));
    }

    public void loadProperties(String dirPath, Properties properties) throws IOException {
        InputStream inputStream = this.classLoader.getResourceAsStream(this.templateSourceDir + dirPath + "/jamon.properties");
        if (inputStream != null) {
            properties.load(inputStream);
        }
    }
}

