/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.compiler;

import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jamon.AbstractTemplateProxy;
import org.jamon.TemplateManager;
import org.jamon.TemplateManagerSource;
import org.jamon.annotations.Argument;
import org.jamon.annotations.Template;
import org.jamon.compiler.JamonException;
import org.jamon.util.StringUtils;

public class TemplateInspector {
    private final Class<?> templateClass;
    private final AbstractTemplateProxy template;
    private final Method renderMethod;
    private final List<String> requiredArgNames;
    private final List<String> optionalArgNames;

    public TemplateInspector(String p_templateName) throws InvalidTemplateException {
        this(TemplateManagerSource.getTemplateManagerFor((String)p_templateName), p_templateName);
    }

    public TemplateInspector(TemplateManager manager, String templateName) throws InvalidTemplateException {
        this.template = manager.constructProxy(templateName);
        this.templateClass = this.template.getClass();
        Method[] methods = this.templateClass.getMethods();
        Method renderMethod = null;
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals("render")) continue;
            renderMethod = methods[i];
            break;
        }
        if (renderMethod == null) {
            throw new InvalidTemplateException(templateName);
        }
        this.renderMethod = renderMethod;
        Template templateAnnotation = this.templateClass.getAnnotation(Template.class);
        this.requiredArgNames = this.getArgNames(templateAnnotation.requiredArguments());
        this.optionalArgNames = this.getArgNames(templateAnnotation.optionalArguments());
    }

    private List<String> getArgNames(Argument[] arguments) {
        ArrayList<String> argumentNames = new ArrayList<String>(arguments.length);
        for (Argument argument : arguments) {
            argumentNames.add(argument.name());
        }
        return argumentNames;
    }

    public void render(Writer writer, Map<String, Object> argMap) throws InvalidTemplateException, UnknownArgumentsException {
        this.render(writer, argMap, false);
    }

    public void render(Writer writer, Map<String, Object> argMap, boolean ignoreUnusedParams) throws InvalidTemplateException, UnknownArgumentsException {
        try {
            if (!ignoreUnusedParams) {
                this.validateArguments(argMap);
            }
            this.invokeOptionalArguments(argMap);
            this.renderMethod.invoke((Object)this.template, this.computeRenderArguments(argMap, writer));
        }
        catch (IllegalAccessException e) {
            throw new InvalidTemplateException(this.templateClass.getName(), e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new InvalidTemplateException(this.templateClass.getName(), t);
        }
    }

    public List<String> getRequiredArgumentNames() {
        return this.requiredArgNames;
    }

    public List<String> getOptionalArgumentNames() {
        return this.optionalArgNames;
    }

    public Class<?> getArgumentType(String argName) {
        if (this.optionalArgNames.contains(argName)) {
            return this.findSetMethod(argName).getParameterTypes()[0];
        }
        int i = this.requiredArgNames.indexOf(argName);
        if (i < 0) {
            return null;
        }
        return this.renderMethod.getParameterTypes()[i + 1];
    }

    private Object[] computeRenderArguments(Map<String, Object> argMap, Writer writer) {
        Object[] actuals = new Object[1 + this.requiredArgNames.size()];
        actuals[0] = writer;
        for (int i = 0; i < this.requiredArgNames.size(); ++i) {
            actuals[i + 1] = argMap.get(this.requiredArgNames.get(i));
        }
        return actuals;
    }

    private void invokeOptionalArguments(Map<String, Object> argMap) throws InvalidTemplateException {
        for (int i = 0; i < this.optionalArgNames.size(); ++i) {
            String name = this.optionalArgNames.get(i);
            if (!argMap.containsKey(name)) continue;
            this.invokeSet(name, argMap.get(name));
        }
    }

    private void validateArguments(Map<String, Object> argMap) throws UnknownArgumentsException {
        HashSet<String> argNames = new HashSet<String>();
        argNames.addAll(argMap.keySet());
        argNames.removeAll(this.requiredArgNames);
        argNames.removeAll(this.optionalArgNames);
        if (!argNames.isEmpty()) {
            StringBuilder msg = new StringBuilder("Unknown arguments supplied: ");
            StringUtils.commaJoin(msg, argNames);
            throw new UnknownArgumentsException(msg.toString());
        }
    }

    private Method findSetMethod(String name) {
        Method[] methods = this.templateClass.getMethods();
        String upperName = "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(upperName) || methods[i].getParameterTypes().length != 1) continue;
            return methods[i];
        }
        return null;
    }

    private void invokeSet(String name, Object value) throws InvalidTemplateException {
        Method setMethod = this.findSetMethod(name);
        if (setMethod == null) {
            throw new InvalidTemplateException(this.templateClass.getName() + " has no set method for " + name);
        }
        try {
            setMethod.invoke((Object)this.template, value);
        }
        catch (IllegalAccessException e) {
            throw new InvalidTemplateException(this.templateClass.getName(), e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new InvalidTemplateException(this.templateClass.getName(), t);
        }
    }

    public static class UnknownArgumentsException
    extends JamonException {
        private static final long serialVersionUID = 2006091701L;

        UnknownArgumentsException(String msg) {
            super(msg);
        }
    }

    public static class InvalidTemplateException
    extends Exception {
        private static final long serialVersionUID = 2006091701L;

        public InvalidTemplateException(String p_templateName) {
            this(p_templateName, null);
        }

        public InvalidTemplateException(String p_templateName, Throwable t) {
            super(p_templateName + " does not appear to be a valid template class", t);
        }
    }
}

