/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.node;

import java.util.ArrayList;
import java.util.List;
import org.jamon.api.Location;
import org.jamon.node.AbstractArgsNode;
import org.jamon.node.AbstractNode;
import org.jamon.node.Analysis;

public class AbsMethodNode
extends AbstractNode {
    private final String name;
    private final List<AbstractArgsNode> argsBlocks = new ArrayList<AbstractArgsNode>();

    public AbsMethodNode(Location location, String name) {
        super(location);
        this.name = name;
        if (this.name == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public void apply(Analysis analysis) {
        analysis.caseAbsMethodNode(this);
    }

    public String getName() {
        return this.name;
    }

    public AbsMethodNode addArgsBlock(AbstractArgsNode argsBlock) {
        if (argsBlock == null) {
            throw new NullPointerException();
        }
        this.argsBlocks.add(argsBlock);
        return this;
    }

    public List<AbstractArgsNode> getArgsBlocks() {
        return this.argsBlocks;
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && super.equals(obj) && this.name.equals(((AbsMethodNode)obj).name) && this.argsBlocks.equals(((AbsMethodNode)obj).argsBlocks);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.name.hashCode() ^ this.argsBlocks.hashCode();
    }

    @Override
    protected void propertiesToString(StringBuilder buffer) {
        super.propertiesToString(buffer);
        AbsMethodNode.addProperty(buffer, "name", this.name);
        AbsMethodNode.addPropertyList(buffer, "argsBlock", this.argsBlocks);
    }
}

