/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.node;

import java.util.ArrayList;
import java.util.List;
import org.jamon.api.Location;
import org.jamon.node.AbstractCallNode;
import org.jamon.node.AbstractParamsNode;
import org.jamon.node.AbstractPathNode;
import org.jamon.node.Analysis;
import org.jamon.node.GenericCallParam;

public class AbstractComponentCallNode
extends AbstractCallNode {
    private final AbstractPathNode callPath;
    private final List<GenericCallParam> genericParams = new ArrayList<GenericCallParam>();
    private final AbstractParamsNode params;

    public AbstractComponentCallNode(Location location, AbstractPathNode callPath, AbstractParamsNode params) {
        super(location);
        this.callPath = callPath;
        if (this.callPath == null) {
            throw new NullPointerException();
        }
        this.params = params;
        if (this.params == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public void apply(Analysis analysis) {
        analysis.caseAbstractComponentCallNode(this);
    }

    public AbstractPathNode getCallPath() {
        return this.callPath;
    }

    public AbstractComponentCallNode addGenericParam(GenericCallParam genericParam) {
        if (genericParam == null) {
            throw new NullPointerException();
        }
        this.genericParams.add(genericParam);
        return this;
    }

    public List<GenericCallParam> getGenericParams() {
        return this.genericParams;
    }

    public AbstractParamsNode getParams() {
        return this.params;
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && super.equals(obj) && this.callPath.equals(((AbstractComponentCallNode)obj).callPath) && this.genericParams.equals(((AbstractComponentCallNode)obj).genericParams) && this.params.equals(((AbstractComponentCallNode)obj).params);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.callPath.hashCode() ^ this.genericParams.hashCode() ^ this.params.hashCode();
    }

    @Override
    protected void propertiesToString(StringBuilder buffer) {
        super.propertiesToString(buffer);
        AbstractComponentCallNode.addProperty(buffer, "callPath", this.callPath);
        AbstractComponentCallNode.addPropertyList(buffer, "genericParam", this.genericParams);
        AbstractComponentCallNode.addProperty(buffer, "params", this.params);
    }
}

