/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.node;

import java.util.ArrayList;
import java.util.List;
import org.jamon.api.Location;
import org.jamon.node.AbstractNode;
import org.jamon.node.Analysis;
import org.jamon.node.GenericsBoundNode;

public class GenericsParamNode
extends AbstractNode {
    private final String name;
    private final List<GenericsBoundNode> bounds = new ArrayList<GenericsBoundNode>();

    public GenericsParamNode(Location location, String name) {
        super(location);
        this.name = name;
        if (this.name == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public void apply(Analysis analysis) {
        analysis.caseGenericsParamNode(this);
    }

    public String getName() {
        return this.name;
    }

    public GenericsParamNode addBound(GenericsBoundNode bound) {
        if (bound == null) {
            throw new NullPointerException();
        }
        this.bounds.add(bound);
        return this;
    }

    public List<GenericsBoundNode> getBounds() {
        return this.bounds;
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && super.equals(obj) && this.name.equals(((GenericsParamNode)obj).name) && this.bounds.equals(((GenericsParamNode)obj).bounds);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.name.hashCode() ^ this.bounds.hashCode();
    }

    @Override
    protected void propertiesToString(StringBuilder buffer) {
        super.propertiesToString(buffer);
        GenericsParamNode.addProperty(buffer, "name", this.name);
        GenericsParamNode.addPropertyList(buffer, "bound", this.bounds);
    }
}

