/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.parser;

import java.io.IOException;
import org.jamon.api.Location;
import org.jamon.compiler.ParserErrorImpl;
import org.jamon.compiler.ParserErrorsImpl;
import org.jamon.node.AbstractArgsNode;
import org.jamon.node.ArgNameNode;
import org.jamon.node.ArgNode;
import org.jamon.node.ArgTypeNode;
import org.jamon.parser.AbstractParser;
import org.jamon.parser.PositionalPushbackReader;

public abstract class AbstractArgsParser
extends AbstractParser {
    public AbstractArgsParser(PositionalPushbackReader reader, ParserErrorsImpl errors, Location tagLocation) throws IOException, ParserErrorImpl {
        super(reader, errors);
        if (this.finishOpenTag(tagLocation)) {
            AbstractArgsNode argsNode = this.makeArgsNode(tagLocation);
            while (true) {
                this.soakWhitespace();
                if (this.readChar('<')) {
                    this.checkArgsTagEnd();
                    this.soakWhitespace();
                    return;
                }
                ArgTypeNode argType = this.readArgType();
                this.soakWhitespace();
                reader.markNodeEnd();
                ArgNameNode argName = new ArgNameNode(reader.getCurrentNodeLocation(), this.readIdentifier(true));
                this.soakWhitespace();
                if (this.readChar(';')) {
                    argsNode.addArg(new ArgNode(argType.getLocation(), argType, argName));
                    continue;
                }
                if (!this.handleDefaultValue(argsNode, argType, argName)) break;
            }
            throw new ParserErrorImpl(reader.getNextLocation(), this.postArgNameTokenError());
        }
    }

    private ArgTypeNode readArgType() throws IOException {
        Location location = this.reader.getNextLocation();
        return new ArgTypeNode(location, this.readType(location));
    }

    protected abstract boolean finishOpenTag(Location var1) throws IOException;

    protected abstract boolean handleDefaultValue(AbstractArgsNode var1, ArgTypeNode var2, ArgNameNode var3) throws IOException, ParserErrorImpl;

    protected abstract void checkArgsTagEnd() throws IOException;

    protected abstract String postArgNameTokenError();

    protected abstract AbstractArgsNode makeArgsNode(Location var1);
}

