/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.parser;

import java.io.IOException;
import org.jamon.api.Location;
import org.jamon.compiler.ParserErrorImpl;
import org.jamon.compiler.ParserErrorsImpl;
import org.jamon.parser.AbstractParser;
import org.jamon.parser.PositionalPushbackReader;

public class AbstractTypeParser
extends AbstractParser {
    public static final String UNEXPECTED_ARRAY_ERROR = "Arrays not allowed in this context";
    protected final StringBuilder typeBuilder = new StringBuilder();

    public AbstractTypeParser(Location location, PositionalPushbackReader reader, ParserErrorsImpl errors) throws IOException, ParserErrorImpl {
        super(reader, errors);
        try {
            this.parseComponent();
            while (this.readAndAppendChar('.', this.typeBuilder)) {
                this.soakWhitespace();
                this.parseComponent();
            }
        }
        catch (AbstractParser.NotAnIdentifierException e) {
            throw new ParserErrorImpl(location, "Bad java type specifier");
        }
        this.checkForArrayBrackets();
    }

    private void parseComponent() throws IOException, AbstractParser.NotAnIdentifierException, ParserErrorImpl {
        this.typeBuilder.append(this.readIdentifierOrThrow());
        this.soakWhitespace();
        this.parseTypeElaborations();
    }

    protected void parseTypeElaborations() throws IOException, AbstractParser.NotAnIdentifierException, ParserErrorImpl {
    }

    protected void checkForArrayBrackets() throws IOException, ParserErrorImpl {
        if (this.readChar('[')) {
            throw new ParserErrorImpl(this.reader.getLocation(), UNEXPECTED_ARRAY_ERROR);
        }
    }

    public String getType() {
        return this.typeBuilder.toString();
    }
}

