/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.parser;

import java.io.IOException;
import org.jamon.api.Location;
import org.jamon.compiler.ParserErrorImpl;
import org.jamon.compiler.ParserErrorsImpl;
import org.jamon.node.AbstractArgsNode;
import org.jamon.node.ArgNameNode;
import org.jamon.node.ArgTypeNode;
import org.jamon.node.ArgValueNode;
import org.jamon.node.ArgsNode;
import org.jamon.node.OptionalArgNode;
import org.jamon.parser.AbstractArgsParser;
import org.jamon.parser.OptionalValueTagEndDetector;
import org.jamon.parser.PositionalPushbackReader;

public class ArgsParser
extends AbstractArgsParser {
    private ArgsNode argsNode;
    public static final String EOF_LOOKING_FOR_SEMI = "Reached end of file while looking for ';'";

    public ArgsParser(PositionalPushbackReader reader, ParserErrorsImpl errors, Location tagLocation) throws IOException, ParserErrorImpl {
        super(reader, errors, tagLocation);
    }

    public ArgsNode getArgsNode() {
        return this.argsNode;
    }

    @Override
    protected AbstractArgsNode makeArgsNode(Location tagLocation) {
        this.argsNode = new ArgsNode(tagLocation);
        return this.argsNode;
    }

    @Override
    protected String postArgNameTokenError() {
        return "Expecting a ';', '=' or '=>'";
    }

    @Override
    protected void checkArgsTagEnd() throws IOException {
        if (!this.checkToken("/%args>")) {
            this.addError(this.reader.getLocation(), "malformed </%args> tag");
        }
    }

    @Override
    protected boolean handleDefaultValue(AbstractArgsNode argsNode, ArgTypeNode argType, ArgNameNode argName) throws IOException, ParserErrorImpl {
        if (this.readChar('=')) {
            this.readChar('>');
            this.soakWhitespace();
            Location valueLocation = this.reader.getNextLocation();
            argsNode.addArg(new OptionalArgNode(argType.getLocation(), argType, argName, new ArgValueNode(valueLocation, this.readJava(valueLocation, new OptionalValueTagEndDetector()))));
            return true;
        }
        return false;
    }

    @Override
    protected boolean finishOpenTag(Location tagLocation) throws IOException {
        return this.checkForTagClosure(tagLocation);
    }
}

