/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.parser;

import java.io.IOException;
import org.jamon.api.Location;
import org.jamon.compiler.ParserErrorImpl;
import org.jamon.compiler.ParserErrorsImpl;
import org.jamon.node.AbstractArgsNode;
import org.jamon.node.ArgNameNode;
import org.jamon.node.ArgTypeNode;
import org.jamon.node.FragmentArgsNode;
import org.jamon.parser.AbstractArgsParser;
import org.jamon.parser.AbstractParser;
import org.jamon.parser.PositionalPushbackReader;

public class FragmentArgsParser
extends AbstractArgsParser {
    public static final String EXPECTING_GREATER = "Expecting '>'";
    public static final String NEED_SEMI = "Expecting a ';'";
    public static final String FRAGMENT_ARGUMENT_HAS_NO_NAME = "Fragment argument has no name";
    private String fragmentName;
    private FragmentArgsNode fragmentArgsNode;

    public FragmentArgsParser(PositionalPushbackReader reader, ParserErrorsImpl errors, Location tagLocation) throws IOException, ParserErrorImpl {
        super(reader, errors, tagLocation);
    }

    public FragmentArgsNode getFragmentArgsNode() {
        return this.fragmentArgsNode;
    }

    @Override
    protected boolean handleDefaultValue(AbstractArgsNode argsNode, ArgTypeNode argType, ArgNameNode argName) {
        return false;
    }

    @Override
    protected void checkArgsTagEnd() throws IOException {
        if (!this.checkToken("/%frag>")) {
            this.addError(this.reader.getLocation(), "malformed </%args> tag");
        }
    }

    @Override
    protected String postArgNameTokenError() {
        return NEED_SEMI;
    }

    @Override
    protected AbstractArgsNode makeArgsNode(Location tagLocation) {
        this.fragmentArgsNode = new FragmentArgsNode(tagLocation, this.fragmentName);
        return this.fragmentArgsNode;
    }

    @Override
    protected boolean finishOpenTag(Location tagLocation) throws IOException {
        if (!this.soakWhitespace()) {
            this.fragmentName = "";
            this.addError(tagLocation, FRAGMENT_ARGUMENT_HAS_NO_NAME);
        } else {
            try {
                this.fragmentName = this.readIdentifierOrThrow();
            }
            catch (AbstractParser.NotAnIdentifierException e) {
                this.addError(tagLocation, FRAGMENT_ARGUMENT_HAS_NO_NAME);
            }
        }
        this.soakWhitespace();
        if (this.readChar('/')) {
            if (!this.readChar('>')) {
                this.addError(this.reader.getCurrentNodeLocation(), EXPECTING_GREATER);
            } else {
                this.fragmentArgsNode = new FragmentArgsNode(tagLocation, this.fragmentName);
                this.soakWhitespace();
            }
            return false;
        }
        return this.checkForTagClosure(tagLocation);
    }
}

