/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.parser;

import java.io.IOException;
import org.jamon.api.Location;
import org.jamon.compiler.ParserErrorImpl;
import org.jamon.compiler.ParserErrorsImpl;
import org.jamon.node.AbstractImportNode;
import org.jamon.node.ImportNode;
import org.jamon.node.StaticImportNode;
import org.jamon.parser.AbstractParser;
import org.jamon.parser.PositionalPushbackReader;

public class ImportParser
extends AbstractParser {
    public static final String MISSING_WHITESPACE_AFTER_STATIC_DECLARATION = "missing whitespace after static declaration";
    private final Location location;
    private String importText;
    private boolean isStatic = false;

    public ImportParser(Location location, PositionalPushbackReader reader, ParserErrorsImpl errors) {
        super(reader, errors);
        this.location = location;
    }

    public ImportParser(PositionalPushbackReader reader, ParserErrorsImpl errors) {
        super(reader, errors);
        this.location = reader.getNextLocation();
    }

    public ImportParser parse() throws IOException, ParserErrorImpl {
        StringBuilder builder = new StringBuilder();
        try {
            String firstComponent = this.readIdentifierOrThrow();
            if ("static".equals(firstComponent)) {
                this.isStatic = true;
                if (!this.soakWhitespace()) {
                    throw new ParserErrorImpl(this.location, MISSING_WHITESPACE_AFTER_STATIC_DECLARATION);
                }
                firstComponent = this.readIdentifierOrThrow();
            }
            this.soakWhitespace();
            builder.append(firstComponent);
            while (this.readAndAppendChar('.', builder)) {
                this.soakWhitespace();
                if (this.readAndAppendChar('*', builder)) break;
                builder.append(this.readIdentifierOrThrow());
                this.soakWhitespace();
            }
            this.importText = builder.toString();
            return this;
        }
        catch (AbstractParser.NotAnIdentifierException e) {
            throw new ParserErrorImpl(this.location, "Bad java type specifier");
        }
    }

    public AbstractImportNode getNode() {
        return this.isStatic ? new StaticImportNode(this.location, this.importText) : new ImportNode(this.location, this.importText);
    }

    public boolean isStatic() {
        return this.isStatic;
    }
}

