/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.parser;

import java.io.IOException;
import java.io.Reader;
import org.jamon.api.Location;
import org.jamon.api.TemplateLocation;
import org.jamon.node.LocationImpl;

public class PositionalPushbackReader {
    private final Reader reader;
    private final TemplateLocation templateLocation;
    int pushedbackCharsPending = 0;
    final int[] pushedbackChars;
    private final Position[] positions;
    private Position currentNodePosition = new Position();

    public PositionalPushbackReader(TemplateLocation templateLocation, Reader reader) {
        this(templateLocation, reader, 1);
    }

    public PositionalPushbackReader(TemplateLocation templateLocation, Reader reader, int pushbackBufferSize) {
        this.reader = reader;
        this.templateLocation = templateLocation;
        this.positions = new Position[pushbackBufferSize + 2];
        for (int i = 0; i < this.positions.length; ++i) {
            this.positions[i] = new Position();
        }
        this.pushedbackChars = new int[pushbackBufferSize];
    }

    public int read() throws IOException {
        int c = this.pushedbackCharsPending > 0 ? this.pushedbackChars[--this.pushedbackCharsPending] : this.reader.read();
        for (int i = this.positions.length - 1; i > 0; --i) {
            this.positions[i].assign(this.positions[i - 1]);
        }
        if (c == 10) {
            this.positions[0].nextRow();
        } else {
            this.positions[0].nextColumn();
        }
        return c;
    }

    public void unread(int c) throws IOException {
        if (this.pushedbackCharsPending >= this.pushedbackChars.length) {
            throw new IOException("Trying to push back characters than allowed");
        }
        this.pushedbackChars[this.pushedbackCharsPending++] = c;
        for (int i = 0; i < this.positions.length - 1; ++i) {
            this.positions[i].assign(this.positions[i + 1]);
        }
    }

    public Location getLocation() {
        return this.positions[1].location(this.templateLocation);
    }

    public Location getNextLocation() {
        return this.positions[0].location(this.templateLocation);
    }

    public boolean isLineStart() {
        return this.positions[1].isLineStart();
    }

    public void markNodeBeginning() {
        this.currentNodePosition.assign(this.positions[1]);
    }

    public void markNodeEnd() {
        this.currentNodePosition.assign(this.positions[0]);
    }

    public Location getCurrentNodeLocation() {
        return this.currentNodePosition.location(this.templateLocation);
    }

    private static class Position {
        private int row = 1;
        private int column = 1;

        private Position() {
        }

        void assign(Position position) {
            this.row = position.row;
            this.column = position.column;
        }

        public void nextColumn() {
            ++this.column;
        }

        public void nextRow() {
            ++this.row;
            this.column = 1;
        }

        public Location location(TemplateLocation templateLocation) {
            return new LocationImpl(templateLocation, this.row, this.column);
        }

        public boolean isLineStart() {
            return this.column == 1;
        }
    }
}

