/**
 * Copyright 2007 The JA-SIG Collaborative.  All rights reserved.
 * See license distributed with this file and
 * available online at http://www.uportal.org/license.html
 */
package org.jasig.web.portlet.mvc;

import java.util.Map;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;

import org.apache.commons.lang.Validate;
import org.jasig.web.service.AjaxPortletSupportService;
import org.jasig.web.service.AjaxPortletSupport.ModelGenerator;
import org.jasig.web.util.ModelPasser;
import org.jasig.web.util.SessionKeyGenerator;
import org.springframework.web.portlet.mvc.AbstractController;

/**
 * Base class for AJAX portlet callbacks that handles passing the model to the ajax response
 * servlet via a unique random attribute.
 * 
 * @author Eric Dalquist
 * @version $Revision$
 */
public abstract class AbstractAjaxController extends AbstractController {
    private final AjaxPortletSupportService ajaxPortletSupportService = new AjaxPortletSupportService();
    private String ajaxServletName = AjaxPortletSupportService.DEFAULT_AJAX_SERVLET_NAME;
    
    /**
     * @see AjaxPortletSupportService#getSessionKeyGenerator()
     */
    public SessionKeyGenerator getSessionKeyGenerator() {
        return this.ajaxPortletSupportService.getSessionKeyGenerator();
    }
    /**
     * @see AjaxPortletSupportService#setSessionKeyGenerator(SessionKeyGenerator)
     */
    public void setSessionKeyGenerator(SessionKeyGenerator sessionKeyGenerator) {
        this.ajaxPortletSupportService.setSessionKeyGenerator(sessionKeyGenerator);
    }
    
    /**
     * @see AjaxPortletSupportService#getModelPasser()
     */
    public ModelPasser getModelPasser() {
        return this.ajaxPortletSupportService.getModelPasser();
    }
    /**
     * @see AjaxPortletSupportService#setModelPasser(ModelPasser)
     */
    public void setModelPasser(ModelPasser modelPasser) {
        this.ajaxPortletSupportService.setModelPasser(modelPasser);
    }
    
    /**
     * @see AjaxPortletSupportService#getAjaxHandlerErrorKey()
     */
    public String getAjaxHandlerErrorKey() {
        return this.ajaxPortletSupportService.getAjaxHandlerErrorKey();
    }
    /**
     * @see AjaxPortletSupportService#setAjaxHandlerErrorKey(String)
     */
    public void setAjaxHandlerErrorKey(String ajaxHandlerErrorKey) {
        this.ajaxPortletSupportService.setAjaxHandlerErrorKey(ajaxHandlerErrorKey);
    }
    
    public String getAjaxServletName() {
        return this.ajaxServletName;
    }
    /**
     * The path to the rendering serlvet do redirect the request to after the model data has been passed.
     * Defaults to the value of {@link AjaxPortletSupportService#DEFAULT_AJAX_SERVLET_NAME} 
     */
    public void setAjaxServletName(String ajaxServletName) {
        Validate.notNull(ajaxServletName);
        this.ajaxServletName = ajaxServletName;
    }
    
    
    /* (non-Javadoc)
     * @see org.springframework.web.portlet.mvc.AbstractController#handleActionRequestInternal(javax.portlet.ActionRequest, javax.portlet.ActionResponse)
     */
    @Override
    protected final void handleActionRequestInternal(ActionRequest request, ActionResponse response) throws Exception {
        this.ajaxPortletSupportService.redirectAjaxResponse(this.ajaxServletName, request, response, new ModelGenerator() {
            public Map<Object, Object> generate(ActionRequest request, ActionResponse response) throws Exception {
                return AbstractAjaxController.this.handleAjaxRequestInternal(request, response);
            }
        });
    }

    /**
     * Called by {@link #handleActionRequestInternal(ActionRequest, ActionResponse)} to handle the ajax callback.
     * The returned model will be passed to the {@link AjaxResponseController} via the {@link ModelPasser#passModelToServlet(ActionRequest, ActionResponse, String, Map)}
     * method.
     * 
     * @see AbstractAjaxController#handleActionRequestInternal(ActionRequest, ActionResponse)
     */
    protected abstract Map<Object, Object> handleAjaxRequestInternal(ActionRequest request, ActionResponse response) throws Exception;
}
