/**
 * Copyright (c) 2000-2009, Jasig, Inc.
 * See license distributed with this file and available online at
 * https://www.ja-sig.org/svn/jasig-parent/tags/rel-10/license-header.txt
 */

package org.jasig.web.service;

import java.io.IOException;
import java.util.Map;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.bind.ServletRequestBindingException;

/**
 * @author Eric Dalquist
 * @version $Revision$
 */
public interface AjaxPortletSupport {
    public static final String DEFAULT_AJAX_SERVLET_NAME = "ajaxResponse";
    public static final String DEFAULT_AJAX_HANDLER_ERROR_KEY = "AJAX_HANDLER_ERROR";
    
    /**
     * Generates the data model to pass to the servlet for rendering.
     */
    public interface ModelGenerator {
        /**
         * @return The data model to pass to the servlet
         * @throws Exception the caller must provide the standard AJAX error handling.
         */
        public Map<Object, Object> generate(ActionRequest request, ActionResponse response) throws Exception;
    }
    
    /**
     * Generates a new session key and uses that to pass the model to the servlet. The response will be redirected
     * to the ajax handling servlet by this method.
     * 
     * @param ajaxServletName Name of the ajax servlet to redirect to
     * @param model The data model to pass to the servlet
     */
    public void redirectAjaxResponse(String ajaxServletName, Map<Object, Object> model, ActionRequest request, ActionResponse response) throws IOException;

    /**
     * Calls {@link #redirectAjaxResponse(String, Map, ActionRequest, ActionResponse)} passing {@link #DEFAULT_AJAX_SERVLET_NAME} for the servlet name.
     */
    public void redirectAjaxResponse(Map<Object, Object> model, ActionRequest request, ActionResponse response) throws IOException;
    
    /**
     * Generates a new session key and uses that to pass the model to the servlet. The response will be redirected
     * to the ajax handling servlet by this method. Handles any exceptions thrown by {@link ModelGenerator#generate(ActionRequest, ActionResponse)}
     * using {@link #DEFAULT_AJAX_HANDLER_ERROR_KEY} as the error key.
     * 
     * @param ajaxServletName Name of the ajax servlet to redirect to
     * @param generator ModelGenerator used to generate the model to pass
     */
    public void redirectAjaxResponse(String ajaxServletName, ActionRequest request, ActionResponse response, ModelGenerator generator) throws IOException;

    /**
     * Calls {@link #redirectAjaxResponse(ActionRequest, ActionResponse, ModelGenerator))} passing {@link #DEFAULT_AJAX_SERVLET_NAME} for the servlet name.
     */
    public void redirectAjaxResponse(ActionRequest request, ActionResponse response, ModelGenerator generator) throws IOException;
    
    /**
     * Gets the model for the request, if the model is null a 404 is sent to the browser and null is returned. If the
     * model contains the key {@link #DEFAULT_AJAX_HANDLER_ERROR_KEY} a 500 is sent to the browser but the model is still
     * returned for rendering.
     */
    public Map<Object, Object> getAjaxModel(HttpServletRequest request, HttpServletResponse response) throws ServletRequestBindingException, IOException;

}