/**
 * Copyright 2007 The JA-SIG Collaborative.  All rights reserved.
 * See license distributed with this file and
 * available online at http://www.uportal.org/license.html
 */
package org.jasig.web.util;

import java.util.Random;

import javax.portlet.PortletSession;

import org.apache.commons.codec.binary.Base64;
import org.springframework.web.portlet.util.PortletUtils;

/**
 * Uses a combination of a random number and in incremented field to generate unique keys
 * 
 * @author Eric Dalquist
 * @version $Revision$
 * @deprecated Use {@link SecureSessionKeyGenerator} instead, it uses a better random number generation approach and is likely more secure
 */
@Deprecated
public class DefaultSessionKeyGenerator implements SessionKeyGenerator {
    public static final String UNIQUE_KEY_SEQ = DefaultSessionKeyGenerator.class.getName() + ".UNIQUE_KEY_SEQ";
    
    private final Random random = new Random(System.currentTimeMillis());
    private int randomKeySize = 34;
    
    public void setSeed(long seed) {
        this.random.setSeed(seed);
    }

    /* (non-Javadoc)
     * @see org.jasig.portlet.notepad.util.SessionKeyGenerator#getNextSessionKey(javax.portlet.PortletSession)
     */
    public String getNextSessionKey(PortletSession session) {
        final long nextId;
        synchronized (PortletUtils.getSessionMutex(session)) {
            final Long lastId = (Long)session.getAttribute(UNIQUE_KEY_SEQ);
            if (lastId != null) {
                nextId = lastId + 1;
            }
            else {
                nextId = 0;
            }
            session.setAttribute(UNIQUE_KEY_SEQ, nextId);
        }
        
        //Generate the random part of the key
        final byte[] rndBytes = new byte[this.randomKeySize];
        this.random.nextBytes(rndBytes);
        
        //Generate the sequential part of the key
        final byte[] idBytes = toByteArray(nextId);
        
        //Build the key array
        final byte[] keyBytes = new byte[rndBytes.length + idBytes.length];
        System.arraycopy(rndBytes, 0, keyBytes, 0, rndBytes.length);
        System.arraycopy(idBytes, 0, keyBytes, rndBytes.length, idBytes.length);
        
        //Encode and return the key
        return new String(Base64.encodeBase64(keyBytes));
    }
    
    private byte[] toByteArray(long v) {
        final byte[] ba = new byte[8];
        ba[0] = (byte)(v >>> 56);
        ba[1] = (byte)(v >>> 48);
        ba[2] = (byte)(v >>> 40);
        ba[3] = (byte)(v >>> 32);
        ba[4] = (byte)(v >>> 24);
        ba[5] = (byte)(v >>> 16);
        ba[6] = (byte)(v >>>  8);
        ba[7] = (byte)(v >>>  0);
        
        return ba;
    }
}
