/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.web.service;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletSession;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.web.service.AjaxPortletSupport;
import org.jasig.web.util.DefaultModelPasser;
import org.jasig.web.util.ModelPasser;
import org.jasig.web.util.SecureSessionKeyGenerator;
import org.jasig.web.util.SessionKeyGenerator;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.ServletRequestUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxPortletSupportService
implements AjaxPortletSupport {
    public static final String SESSION_KEY = "key";
    private Log logger = LogFactory.getLog(AjaxPortletSupportService.class);
    private SessionKeyGenerator sessionKeyGenerator = new SecureSessionKeyGenerator();
    private ModelPasser modelPasser = new DefaultModelPasser();
    private String ajaxHandlerErrorKey = "AJAX_HANDLER_ERROR";

    public SessionKeyGenerator getSessionKeyGenerator() {
        return this.sessionKeyGenerator;
    }

    public void setSessionKeyGenerator(SessionKeyGenerator sessionKeyGenerator) {
        Validate.notNull((Object)sessionKeyGenerator);
        this.sessionKeyGenerator = sessionKeyGenerator;
    }

    public ModelPasser getModelPasser() {
        return this.modelPasser;
    }

    public void setModelPasser(ModelPasser modelPasser) {
        Validate.notNull((Object)modelPasser);
        this.modelPasser = modelPasser;
    }

    public String getAjaxHandlerErrorKey() {
        return this.ajaxHandlerErrorKey;
    }

    public void setAjaxHandlerErrorKey(String ajaxHandlerErrorKey) {
        Validate.notNull((Object)ajaxHandlerErrorKey);
        this.ajaxHandlerErrorKey = ajaxHandlerErrorKey;
    }

    @Override
    public void redirectAjaxResponse(Map<String, ?> model, ActionRequest request, ActionResponse response) throws IOException {
        this.redirectAjaxResponse("ajaxResponse", model, request, response);
    }

    @Override
    public final void redirectAjaxResponse(String ajaxServletName, Map<String, ?> model, ActionRequest request, ActionResponse response) throws IOException {
        PortletSession session = request.getPortletSession();
        String sessionKey = this.sessionKeyGenerator.getNextSessionKey(session);
        this.modelPasser.passModelToServlet(request, response, sessionKey, model);
        String ajaxServletUrl = this.getAjaxServletUrl(request, response, ajaxServletName, sessionKey);
        String encodedAjaxServletUrl = response.encodeURL(ajaxServletUrl);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Redirecting ActionRequest to: " + encodedAjaxServletUrl));
        }
        response.sendRedirect(encodedAjaxServletUrl);
    }

    @Override
    public void redirectAjaxResponse(ActionRequest request, ActionResponse response, AjaxPortletSupport.ModelGenerator generator) throws IOException {
        this.redirectAjaxResponse("ajaxResponse", request, response, generator);
    }

    @Override
    public void redirectAjaxResponse(String ajaxServletName, ActionRequest request, ActionResponse response, AjaxPortletSupport.ModelGenerator generator) throws IOException {
        Map<String, ?> model;
        try {
            model = generator.generate(request, response);
        }
        catch (Exception e) {
            HashMap errorModel = new HashMap();
            this.logger.warn((Object)"An exception occurred during handleAjaxRequestInternal()", (Throwable)e);
            errorModel.put(this.ajaxHandlerErrorKey, e);
            if (!"AJAX_HANDLER_ERROR".equals(this.ajaxHandlerErrorKey)) {
                errorModel.put("AJAX_HANDLER_ERROR", true);
            }
            model = errorModel;
        }
        this.redirectAjaxResponse(ajaxServletName, model, request, response);
    }

    @Override
    public final Map<String, ?> getAjaxModel(HttpServletRequest request, HttpServletResponse response) throws ServletRequestBindingException, IOException {
        String key = ServletRequestUtils.getRequiredStringParameter((ServletRequest)request, (String)SESSION_KEY);
        Map<String, ?> model = this.modelPasser.getModelFromPortlet(request, response, key);
        if (model == null) {
            response.sendError(404, "No model exists in the session for key '" + key + "'");
        } else if (model.containsKey("AJAX_HANDLER_ERROR")) {
            response.setStatus(500);
        }
        return model;
    }

    protected String getAjaxServletUrl(ActionRequest request, ActionResponse response, String ajaxServletName, String sessionKey) throws UnsupportedEncodingException {
        String contextPath = request.getContextPath();
        String characterEncoding = request.getCharacterEncoding();
        String encodedKeyParam = URLEncoder.encode(SESSION_KEY, characterEncoding);
        String encodedSessionKey = URLEncoder.encode(sessionKey, characterEncoding);
        return contextPath + "/" + ajaxServletName + "?" + encodedKeyParam + "=" + encodedSessionKey;
    }
}

