/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.irclog;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.irclog.events.ActionEvent;
import org.jasig.irclog.events.ConnectEvent;
import org.jasig.irclog.events.DisconnectEvent;
import org.jasig.irclog.events.JoinEvent;
import org.jasig.irclog.events.KickEvent;
import org.jasig.irclog.events.MessageEvent;
import org.jasig.irclog.events.ModeEvent;
import org.jasig.irclog.events.NickChangeEvent;
import org.jasig.irclog.events.NoticeEvent;
import org.jasig.irclog.events.PartEvent;
import org.jasig.irclog.events.PingEvent;
import org.jasig.irclog.events.PrivateMessageEvent;
import org.jasig.irclog.events.QuitEvent;
import org.jasig.irclog.events.TimeEvent;
import org.jasig.irclog.events.TopicEvent;
import org.jasig.irclog.events.VersionEvent;
import org.jasig.irclog.events.handlers.IrcEventHandler;
import org.jibble.pircbot.Colors;
import org.jibble.pircbot.PircBot;

public class EventLogBot
extends PircBot {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private IrcEventHandler eventHandler = null;
    private boolean stripFormatting = true;

    public IrcEventHandler getEventHandler() {
        return this.eventHandler;
    }

    public void setEventHandler(IrcEventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    public boolean isStripFormatting() {
        return this.stripFormatting;
    }

    public void setStripFormatting(boolean stripColors) {
        this.stripFormatting = stripColors;
    }

    public void setBotName(String name) {
        this.setName(name);
    }

    protected void onConnect() {
        ConnectEvent event = new ConnectEvent(this);
        this.eventHandler.handleEvent(event);
    }

    protected void onAction(String sender, String login, String hostname, String target, String action) {
        ActionEvent event = new ActionEvent(this, sender, login, hostname, target, action);
        this.eventHandler.handleEvent(event);
    }

    protected void onJoin(String channel, String sender, String login, String hostname) {
        JoinEvent event = new JoinEvent(this, channel, sender, login, hostname);
        this.eventHandler.handleEvent(event);
    }

    protected void onMessage(String channel, String sender, String login, String hostname, String message) {
        if (this.stripFormatting) {
            message = Colors.removeFormattingAndColors((String)message);
        }
        MessageEvent event = new MessageEvent(this, channel, sender, login, hostname, message);
        this.eventHandler.handleEvent(event);
    }

    protected void onMode(String channel, String sourceNick, String sourceLogin, String sourceHostname, String mode) {
        ModeEvent event = new ModeEvent(this, channel, sourceNick, sourceLogin, sourceHostname, mode);
        this.eventHandler.handleEvent(event);
    }

    protected void onNickChange(String oldNick, String login, String hostname, String newNick) {
        NickChangeEvent event = new NickChangeEvent(this, oldNick, login, hostname, newNick);
        this.eventHandler.handleEvent(event);
    }

    protected void onNotice(String sourceNick, String sourceLogin, String sourceHostname, String target, String notice) {
        NoticeEvent event = new NoticeEvent(this, sourceNick, sourceLogin, sourceHostname, target, notice);
        this.eventHandler.handleEvent(event);
    }

    protected void onPart(String channel, String sender, String login, String hostname) {
        PartEvent event = new PartEvent(this, channel, sender, login, hostname);
        this.eventHandler.handleEvent(event);
    }

    protected void onPing(String sourceNick, String sourceLogin, String sourceHostname, String target, String pingValue) {
        PingEvent event = new PingEvent(this, sourceNick, sourceLogin, sourceHostname, target, pingValue);
        this.eventHandler.handleEvent(event);
    }

    protected void onPrivateMessage(String sender, String login, String hostname, String message) {
        if (this.stripFormatting) {
            message = Colors.removeFormattingAndColors((String)message);
        }
        PrivateMessageEvent event = new PrivateMessageEvent(this, sender, login, hostname, message);
        this.eventHandler.handleEvent(event);
    }

    protected void onQuit(String sourceNick, String sourceLogin, String sourceHostname, String reason) {
        QuitEvent event = new QuitEvent(this, sourceNick, sourceLogin, sourceHostname, reason);
        this.eventHandler.handleEvent(event);
    }

    protected void onTime(String sourceNick, String sourceLogin, String sourceHostname, String target) {
        TimeEvent event = new TimeEvent(this, sourceNick, sourceLogin, sourceHostname, target);
        this.eventHandler.handleEvent(event);
    }

    protected void onTopic(String channel, String topic, String setBy, long date, boolean changed) {
        TopicEvent event = new TopicEvent(this, channel, topic, setBy, date, changed);
        this.eventHandler.handleEvent(event);
    }

    protected void onVersion(String sourceNick, String sourceLogin, String sourceHostname, String target) {
        VersionEvent event = new VersionEvent(this, sourceNick, sourceLogin, sourceHostname, target);
        this.eventHandler.handleEvent(event);
    }

    protected void onKick(String channel, String kickerNick, String kickerLogin, String kickerHostname, String recipientNick, String reason) {
        KickEvent event = new KickEvent(this, channel, kickerNick, kickerLogin, kickerHostname, recipientNick, reason);
        this.eventHandler.handleEvent(event);
    }

    protected void onDisconnect() {
        DisconnectEvent event = new DisconnectEvent(this);
        this.eventHandler.handleEvent(event);
    }
}

