/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.irclog.events.handlers;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.irclog.events.ConnectEvent;
import org.jasig.irclog.events.DisconnectEvent;
import org.jasig.irclog.events.IrcEvent;
import org.jasig.irclog.events.KickEvent;
import org.jasig.irclog.events.handlers.IrcEventHandler;
import org.jibble.pircbot.PircBot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelManager
implements IrcEventHandler {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Set<String> channels = new HashSet<String>(0);
    private long reconnectDelay = 1000L;

    public Set<String> getChannels() {
        return this.channels;
    }

    public void setChannels(Set<String> channels) {
        Validate.notNull(channels, (String)"Channels Set can not be null");
        this.channels = channels;
    }

    public void addChannel(String channel) {
        this.channels.add(channel);
    }

    public long getReconnectDelay() {
        return this.reconnectDelay;
    }

    public void setReconnectDelay(long reconnectDelay) {
        this.reconnectDelay = reconnectDelay;
    }

    @Override
    public void handleEvent(IrcEvent event) {
        PircBot bot = event.getSource();
        if (event instanceof ConnectEvent) {
            for (String channel : this.channels) {
                this.logger.info((Object)("Joining '" + channel + "'"));
                bot.joinChannel(channel);
            }
        } else if (event instanceof DisconnectEvent) {
            this.logger.info((Object)"Disconnected from server.");
            while (!bot.isConnected()) {
                try {
                    this.logger.info((Object)"Attempting to reconnect to server.");
                    bot.reconnect();
                }
                catch (Exception e) {
                    this.logger.error((Object)"Failed to reconnect", (Throwable)e);
                    try {
                        Thread.sleep(this.reconnectDelay);
                    }
                    catch (InterruptedException ie) {
                        this.logger.error((Object)"Failed to wait to reconnect", (Throwable)ie);
                    }
                }
            }
        } else if (event instanceof KickEvent) {
            String nick = bot.getNick();
            KickEvent kickEvent = (KickEvent)event;
            String recipientNick = kickEvent.getRecipientNick();
            String channel = kickEvent.getChannel();
            if (this.channels.contains(channel) && nick.equalsIgnoreCase(recipientNick)) {
                this.logger.info((Object)("Kicked from channel '" + channel + "' attempting to rejoin."));
                bot.joinChannel(kickEvent.getChannel());
            }
        }
    }
}

