/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.irclog.events.handlers;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.irclog.events.IrcEvent;
import org.jasig.irclog.events.handlers.IrcEventHandler;
import org.jasig.irclog.messages.MessageHandler;

public class FormattingEventHandler
implements IrcEventHandler {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private MessageHandler messageHandler;
    private Properties eventFormats;

    public Properties getEventFormats() {
        return this.eventFormats;
    }

    public void setEventFormats(Properties eventFormats) {
        this.eventFormats = eventFormats;
    }

    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public void setMessageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public void handleEvent(IrcEvent event) {
        Object[] eventArgs = event.getArguments();
        Object[] formatArgs = new Object[eventArgs.length + 1];
        formatArgs[0] = event.getEventCode();
        System.arraycopy(eventArgs, 0, formatArgs, 1, eventArgs.length);
        String messagePattern = this.getMessageFormatPattern(event, formatArgs.length);
        try {
            String message = MessageFormat.format(messagePattern, formatArgs);
            this.messageHandler.handleMessages(message);
        }
        catch (IllegalArgumentException iae) {
            this.logger.error((Object)("Failed to format arguments " + Arrays.asList(formatArgs) + " using pattern '" + messagePattern + "'"), (Throwable)iae);
        }
    }

    protected String getMessageFormatPattern(IrcEvent event, int argCount) {
        String pattern = this.eventFormats != null ? this.eventFormats.getProperty(event.getEventCode()) : null;
        if (pattern != null) {
            return pattern;
        }
        return this.getDefaultMessageFormat(argCount);
    }

    protected String getDefaultMessageFormat(int arguments) {
        StringBuilder msgFormat = new StringBuilder();
        if (arguments > 1) {
            msgFormat.append("{0}");
        }
        if (arguments > 2) {
            msgFormat.append("@{1}");
        }
        if (arguments > 3) {
            msgFormat.append(" - ");
            for (int index = 2; index < arguments; ++index) {
                msgFormat.append("{").append(index).append("}");
                if (index + 1 >= arguments) continue;
                msgFormat.append(", ");
            }
        }
        return msgFormat.toString();
    }
}

