/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.irclog.events.handlers;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.irclog.events.ConnectEvent;
import org.jasig.irclog.events.IrcEvent;
import org.jasig.irclog.events.handlers.IrcEventHandler;
import org.jibble.pircbot.PircBot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NickAuthHandler
implements IrcEventHandler {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Map<String, String> passwords = new HashMap<String, String>(0);

    public Map<String, String> getPasswords() {
        return this.passwords;
    }

    public void setPasswords(Map<String, String> passwords) {
        Validate.notNull(passwords, (String)"Passwords Map can not be null");
        this.passwords = passwords;
    }

    public void addPassword(String nick, String password) {
        this.passwords.put(nick, password);
    }

    @Override
    public void handleEvent(IrcEvent event) {
        if (event instanceof ConnectEvent) {
            PircBot bot = event.getSource();
            String nick = bot.getNick();
            String password = this.passwords.get(nick);
            if (password != null) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Authenticating '" + nick + "'."));
                }
                bot.identify(password);
            } else if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("No password set for '" + nick + "', not authenticating."));
            }
        }
    }
}

