/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.irclog.events.handlers.filter;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jasig.irclog.events.ChannelEvent;
import org.jasig.irclog.events.IrcEvent;
import org.jasig.irclog.events.handlers.filter.EventFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelEventFilter
implements EventFilter {
    private Set<String> channels = new HashSet<String>(0);

    public ChannelEventFilter() {
    }

    public ChannelEventFilter(String ... channel) {
        this.channels.addAll(Arrays.asList(channel));
    }

    public Set<String> getChannels() {
        return this.channels;
    }

    public void setChannels(Set<String> channels) {
        Validate.notNull(channels, (String)"channels Set cannot be null");
        this.channels = channels;
    }

    @Override
    public boolean filterEvent(IrcEvent event) {
        if (event instanceof ChannelEvent) {
            ChannelEvent channelEvent = (ChannelEvent)event;
            String channel = channelEvent.getChannel();
            return this.channels.contains(channel);
        }
        return false;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("channels", this.channels).toString();
    }
}

