/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.proxy;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.client.proxy.ProxyRetriever;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.util.XmlUtils;

public final class Cas20ProxyRetriever
implements ProxyRetriever {
    protected final Log log = LogFactory.getLog(this.getClass());
    private final String casServerUrl;
    private final HttpClient httpClient;

    public Cas20ProxyRetriever(String casServerUrl, HttpClient httpClient) {
        CommonUtils.assertNotNull(casServerUrl, "casServerUrl cannot be null.");
        CommonUtils.assertNotNull(httpClient, "httpClient cannot be null.");
        this.casServerUrl = casServerUrl;
        this.httpClient = httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProxyTicketIdFor(String proxyGrantingTicketId, Service targetService) {
        String url = this.constructUrl(proxyGrantingTicketId, targetService.getId());
        GetMethod method = new GetMethod(url);
        try {
            this.httpClient.executeMethod((HttpMethod)method);
            String response = method.getResponseBodyAsString();
            String error = XmlUtils.getTextForElement(response, "proxyFailure");
            if (CommonUtils.isNotEmpty(error)) {
                this.log.debug((Object)error);
                String string = null;
                return string;
            }
            String string = XmlUtils.getTextForElement(response, "proxyTicket");
            return string;
        }
        catch (IOException e) {
            this.log.error((Object)e, (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            method.releaseConnection();
        }
    }

    private String constructUrl(String proxyGrantingTicketId, String targetService) {
        try {
            return this.casServerUrl + "proxy" + "?pgt=" + proxyGrantingTicketId + "&targetService=" + URLEncoder.encode(targetService, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

