/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.validation;

import java.net.URLEncoder;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.TicketValidator;
import org.jasig.cas.client.validation.ValidationException;

public abstract class AbstractUrlBasedTicketValidator
implements TicketValidator {
    protected final Log log = LogFactory.getLog(this.getClass());
    private final String casServerUrl;
    private final boolean renew;
    private final HttpClient httpClient;

    public final Assertion validate(String ticketId, Service service) throws ValidationException {
        String url = this.constructURL(ticketId, service);
        String response = this.getResponseFromURL(url);
        return this.parseResponse(response);
    }

    protected abstract String constructURL(String var1, Service var2);

    protected abstract Assertion parseResponse(String var1) throws ValidationException;

    private String getResponseFromURL(String url) throws ValidationException {
        GetMethod method = new GetMethod(url);
        try {
            this.httpClient.executeMethod((HttpMethod)method);
            String string = method.getResponseBodyAsString();
            return string;
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new ValidationException("Unable to retrieve response from CAS Server.", e);
        }
        finally {
            method.releaseConnection();
        }
    }

    protected AbstractUrlBasedTicketValidator(String casServerUrl, boolean renew, HttpClient httpClient) {
        CommonUtils.assertNotNull(casServerUrl, "the validationUrl cannot be null");
        CommonUtils.assertNotNull(httpClient, "httpClient cannot be null.");
        this.casServerUrl = casServerUrl;
        this.renew = renew;
        this.httpClient = httpClient;
    }

    protected final String getEncodedService(Service service) {
        try {
            return URLEncoder.encode(service.getId(), "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected final String getCasServerUrl() {
        return this.casServerUrl;
    }

    protected final boolean isRenew() {
        return this.renew;
    }
}

