/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.validation;

import java.util.HashMap;
import java.util.Map;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.client.proxy.ProxyRetriever;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.Assertion;

public class AssertionImpl
implements Assertion {
    private static final long serialVersionUID = 1L;
    private final Map attributes;
    private final Principal principal;
    private final String proxyGrantingTicketId;
    private final ProxyRetriever proxyRetriever;

    public AssertionImpl(Principal principal) {
        this(principal, null, null, null);
    }

    public AssertionImpl(Principal principal, Map attributes) {
        this(principal, attributes, null, null);
    }

    public AssertionImpl(Principal principal, Map attributes, ProxyRetriever proxyRetriever, String proxyGrantingTicketId) {
        CommonUtils.assertNotNull(principal, "principal cannot be null");
        this.principal = principal;
        this.attributes = attributes == null ? new HashMap() : attributes;
        this.proxyGrantingTicketId = CommonUtils.isNotEmpty(proxyGrantingTicketId) ? proxyGrantingTicketId : null;
        this.proxyRetriever = proxyRetriever;
    }

    public final Map getAttributes() {
        return this.attributes;
    }

    public String getProxyTicketFor(Service service) {
        if (this.proxyRetriever == null || this.proxyGrantingTicketId == null) {
            return null;
        }
        return this.proxyRetriever.getProxyTicketIdFor(this.proxyGrantingTicketId, service);
    }

    public final Principal getPrincipal() {
        return this.principal;
    }
}

