/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.validation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.apache.commons.httpclient.HttpClient;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.SimplePrincipal;
import org.jasig.cas.client.validation.AbstractUrlBasedTicketValidator;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.AssertionImpl;
import org.jasig.cas.client.validation.ValidationException;

public final class Cas10TicketValidator
extends AbstractUrlBasedTicketValidator {
    public Cas10TicketValidator(String casServerUrl, boolean renew, HttpClient httpClient) {
        super(casServerUrl, renew, httpClient);
    }

    protected String constructURL(String ticketId, Service service) {
        return this.getCasServerUrl() + "validate?ticket=" + ticketId + (this.isRenew() ? "&renew=true" : "") + "&service=" + this.getEncodedService(service);
    }

    protected final Assertion parseResponse(String response) throws ValidationException {
        if (response == null || "no\n\n".equals(response) || !response.startsWith("yes")) {
            throw new ValidationException("'No' response returned from server for validation request.");
        }
        try {
            BufferedReader reader = new BufferedReader(new StringReader(response));
            reader.readLine();
            SimplePrincipal principal = new SimplePrincipal(reader.readLine());
            return new AssertionImpl((Principal)principal, null);
        }
        catch (IOException e) {
            throw new ValidationException("Unable to parse response.", e);
        }
    }
}

