/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.validation;

import org.apache.commons.httpclient.HttpClient;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.SimplePrincipal;
import org.jasig.cas.client.proxy.ProxyGrantingTicketStorage;
import org.jasig.cas.client.proxy.ProxyRetriever;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.util.XmlUtils;
import org.jasig.cas.client.validation.AbstractUrlBasedTicketValidator;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.AssertionImpl;
import org.jasig.cas.client.validation.ValidationException;

public class Cas20ServiceTicketValidator
extends AbstractUrlBasedTicketValidator {
    private final Service proxyCallbackUrl;
    private final ProxyGrantingTicketStorage proxyGrantingTicketStorage;
    private final ProxyRetriever proxyRetriever;

    public Cas20ServiceTicketValidator(String casServerUrl, boolean renew, HttpClient httpClient) {
        this(casServerUrl, renew, httpClient, null, null, null);
    }

    public Cas20ServiceTicketValidator(String casServerUrl, boolean renew, HttpClient httpClient, Service proxyCallbackUrl, ProxyGrantingTicketStorage proxyGrantingTicketStorage, ProxyRetriever proxyRetriever) {
        super(casServerUrl, renew, httpClient);
        if (proxyCallbackUrl != null) {
            CommonUtils.assertNotNull(proxyGrantingTicketStorage, "proxyGrantingTicketStorage cannot be null");
            CommonUtils.assertNotNull(proxyRetriever, "proxyRetriever cannot be null.");
        }
        this.proxyCallbackUrl = proxyCallbackUrl;
        this.proxyGrantingTicketStorage = proxyGrantingTicketStorage;
        this.proxyRetriever = proxyRetriever;
    }

    protected String constructURL(String ticketId, Service service) {
        return this.getCasServerUrl() + this.getValidationUrlName() + "?ticket=" + ticketId + (this.isRenew() ? "&renew=true" : "") + "&service=" + this.getEncodedService(service) + (this.proxyCallbackUrl != null ? "&pgtUrl=" + this.getEncodedService(this.proxyCallbackUrl) : "");
    }

    protected final Assertion parseResponse(String response) throws ValidationException {
        String error = XmlUtils.getTextForElement(response, "authenticationFailure");
        if (CommonUtils.isNotBlank(error)) {
            this.log.debug((Object)("Validation of ticket failed: " + error));
            throw new ValidationException(error);
        }
        String principal = XmlUtils.getTextForElement(response, "user");
        String proxyGrantingTicketIou = XmlUtils.getTextForElement(response, "proxyGrantingTicket");
        if (CommonUtils.isEmpty(principal)) {
            throw new ValidationException("No principal found.");
        }
        return this.getValidAssertionInternal(response, principal, proxyGrantingTicketIou);
    }

    protected String getValidationUrlName() {
        return "serviceValidate";
    }

    protected final Assertion getAssertionBasedOnProxyGrantingTicketIou(String proxyGrantingTicketIou, String principal) {
        if (CommonUtils.isNotBlank(proxyGrantingTicketIou)) {
            return new AssertionImpl((Principal)new SimplePrincipal(principal), null, this.proxyRetriever, this.proxyGrantingTicketStorage == null ? null : this.proxyGrantingTicketStorage.retrieve(proxyGrantingTicketIou));
        }
        return new AssertionImpl((Principal)new SimplePrincipal(principal));
    }

    protected Assertion getValidAssertionInternal(String response, String principal, String proxyGrantingTicketIou) throws ValidationException {
        return this.getAssertionBasedOnProxyGrantingTicketIou(proxyGrantingTicketIou, principal);
    }
}

