/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.web.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.client.authorization.AuthorizationException;
import org.jasig.cas.client.authorization.AuthorizedDecider;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.Assertion;
import org.springframework.web.util.WebUtils;

public final class AuthorizationFilter
implements Filter {
    private final Log log = LogFactory.getLog(this.getClass());
    private final AuthorizedDecider decider;

    public AuthorizationFilter(AuthorizedDecider casAuthorizedDecider) {
        CommonUtils.assertNotNull(casAuthorizedDecider, "the casAuthorizedDecider cannot be null.");
        this.decider = casAuthorizedDecider;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        Assertion assertion = (Assertion)WebUtils.getRequiredSessionAttribute((HttpServletRequest)request, (String)"_cas_assertion_");
        Principal principal = assertion.getPrincipal();
        boolean authorized = this.decider.isAuthorizedToUseApplication(principal);
        if (!authorized) {
            this.log.debug((Object)"User not authorized to access application.");
            response.setStatus(403);
            throw new AuthorizationException(principal.getId() + " is not authorized to use this application.");
        }
        this.log.debug((Object)"User successfully authorized.");
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }
}

