/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.integration.uportal;

import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.client.integration.uportal.ICasSecurityContext;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.TicketValidator;
import org.jasig.cas.client.validation.ValidationException;
import org.jasig.portal.security.PortalSecurityException;
import org.jasig.portal.security.provider.ChainingSecurityContext;

public class CasSecurityContext
extends ChainingSecurityContext
implements ICasSecurityContext {
    private static final long serialVersionUID = 1L;
    private final TicketValidator ticketValidator;
    private final Service service;
    private Assertion assertion;

    public CasSecurityContext(TicketValidator ticketValidator, Service service) {
        CommonUtils.assertNotNull((Object)ticketValidator, (String)"ticketValidator cannot be null.");
        CommonUtils.assertNotNull((Object)service, (String)"service cannot be null.");
        this.log.trace((Object)"Initalizing CasSecurityContext");
        this.ticketValidator = ticketValidator;
        this.service = service;
    }

    public final String getProxyTicket(Service targetService) {
        return this.assertion.getProxyTicketFor(targetService);
    }

    public final int getAuthType() {
        return 5889;
    }

    public final synchronized void authenticate() throws PortalSecurityException {
        this.isauth = false;
        String serviceTicket = new String(this.myOpaqueCredentials.credentialstring);
        Service service = this.getService();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Attempting to validate ticket [" + serviceTicket + "] for service [" + service.toString()));
        }
        try {
            this.assertion = this.ticketValidator.validate(serviceTicket, service);
            this.myAdditionalDescriptor = null;
            this.myPrincipal.setUID(this.assertion.getPrincipal().getId());
            this.isauth = true;
            super.authenticate();
        }
        catch (ValidationException e) {
            this.log.warn((Object)e, (Throwable)e);
            throw new PortalSecurityException(e.getMessage(), (Throwable)e);
        }
    }

    protected Service getService() {
        return this.service;
    }
}

