/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services.web;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ReloadableServicesManager;
import org.jasig.cas.services.web.AbstractManagementController;
import org.jasig.cas.services.web.beans.RegisteredServiceEditBean;
import org.jasig.cas.web.view.JsonViewUtils;
import org.jasig.services.persondir.IPersonAttributeDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public final class RegisteredServiceSimpleFormController
extends AbstractManagementController {
    @NotNull
    private final IPersonAttributeDao personAttributeDao;

    @Autowired
    public RegisteredServiceSimpleFormController(ReloadableServicesManager servicesManager, IPersonAttributeDao personAttributeDao) {
        super(servicesManager);
        this.personAttributeDao = personAttributeDao;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"saveService.html"})
    public void saveService(HttpServletRequest request, HttpServletResponse response, @RequestBody RegisteredServiceEditBean.ServiceData service, BindingResult result) {
        try {
            RegisteredService svcToUse = service.toRegisteredService(this.personAttributeDao);
            RegisteredService newSvc = this.servicesManager.save(svcToUse);
            this.logger.info("Saved changes to service {}", (Object)svcToUse.getId());
            HashMap<String, Number> model = new HashMap<String, Number>();
            model.put("id", newSvc.getId());
            model.put("status", 200);
            JsonViewUtils.render(model, (HttpServletResponse)response);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"getService.html"})
    public void getServiceById(@RequestParam(value="id", required=false) Long id, HttpServletRequest request, HttpServletResponse response) {
        try {
            RegisteredServiceEditBean bean = null;
            if (id == -1L) {
                bean = new RegisteredServiceEditBean();
                bean.setServiceData(null);
            } else {
                RegisteredService service = this.servicesManager.findServiceBy(id.longValue());
                if (service == null) {
                    this.logger.warn("Invalid service id specified [{}]. Cannot find service in the registry", (Object)id);
                    throw new IllegalArgumentException("Service id cannot be found");
                }
                bean = RegisteredServiceEditBean.fromRegisteredService((RegisteredService)service);
            }
            RegisteredServiceEditBean.FormData formData = bean.getFormData();
            ArrayList possibleAttributeNames = new ArrayList(this.personAttributeDao.getPossibleUserAttributeNames());
            Collections.sort(possibleAttributeNames);
            formData.setAvailableAttributes(possibleAttributeNames);
            bean.setStatus(200);
            JsonViewUtils.render((Object)bean, (HttpServletResponse)response);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

