/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services.web.beans;

import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import javax.cache.expiry.Duration;
import org.jasig.cas.authentication.principal.CachingPrincipalAttributesRepository;
import org.jasig.cas.authentication.principal.DefaultPrincipalAttributesRepository;
import org.jasig.cas.authentication.principal.PersistentIdGenerator;
import org.jasig.cas.authentication.principal.PrincipalAttributesRepository;
import org.jasig.cas.authentication.principal.ShibbolethCompatiblePersistentIdGenerator;
import org.jasig.cas.services.AbstractAttributeReleasePolicy;
import org.jasig.cas.services.AnonymousRegisteredServiceUsernameAttributeProvider;
import org.jasig.cas.services.AttributeFilter;
import org.jasig.cas.services.DefaultRegisteredServiceAccessStrategy;
import org.jasig.cas.services.DefaultRegisteredServiceUsernameProvider;
import org.jasig.cas.services.LogoutType;
import org.jasig.cas.services.PrincipalAttributeRegisteredServiceUsernameProvider;
import org.jasig.cas.services.RefuseRegisteredServiceProxyPolicy;
import org.jasig.cas.services.RegexMatchingRegisteredServiceProxyPolicy;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.RegisteredServiceProxyPolicy;
import org.jasig.cas.services.RegisteredServicePublicKey;
import org.jasig.cas.services.RegisteredServiceUsernameAttributeProvider;
import org.jasig.cas.services.ReturnAllAttributeReleasePolicy;
import org.jasig.cas.services.ReturnAllowedAttributeReleasePolicy;
import org.jasig.cas.services.ReturnMappedAttributeReleasePolicy;
import org.jasig.cas.services.support.RegisteredServiceRegexAttributeFilter;
import org.jasig.cas.services.web.beans.AbstractRegisteredServiceAttributeReleasePolicyStrategyBean;
import org.jasig.cas.services.web.beans.RegisteredServiceAttributeReleasePolicyEditBean;
import org.jasig.cas.services.web.beans.RegisteredServiceAttributeReleasePolicyStrategyEditBean;
import org.jasig.cas.services.web.beans.RegisteredServiceEditBean;
import org.jasig.cas.services.web.beans.RegisteredServiceLogoutTypeEditBean;
import org.jasig.cas.services.web.beans.RegisteredServiceOAuthTypeEditBean;
import org.jasig.cas.services.web.beans.RegisteredServiceProxyPolicyBean;
import org.jasig.cas.services.web.beans.RegisteredServicePublicKeyEditBean;
import org.jasig.cas.services.web.beans.RegisteredServiceSupportAccessEditBean;
import org.jasig.cas.services.web.beans.RegisteredServiceTypeEditBean;
import org.jasig.cas.services.web.beans.RegisteredServiceUsernameAttributeProviderEditBean;
import org.jasig.cas.support.oauth.services.OAuthRegisteredCallbackAuthorizeService;
import org.jasig.cas.support.oauth.services.OAuthRegisteredService;
import org.jasig.services.persondir.support.merger.IAttributeMerger;
import org.jasig.services.persondir.support.merger.MultivaluedAttributeMerger;
import org.jasig.services.persondir.support.merger.NoncollidingAttributeAdder;
import org.jasig.services.persondir.support.merger.ReplacingAttributeAdder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class RegisteredServiceEditBean
implements Serializable {
    private static final long serialVersionUID = 4882440567964605644L;
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisteredServiceEditBean.class);
    private FormData formData = new FormData();
    private ServiceData serviceData = new ServiceData();
    private int status = -1;

    public ServiceData getServiceData() {
        return this.serviceData;
    }

    public void setServiceData(ServiceData serviceData) {
        this.serviceData = serviceData;
    }

    public FormData getFormData() {
        return this.formData;
    }

    public void setFormData(FormData formData) {
        this.formData = formData;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public static RegisteredServiceEditBean fromRegisteredService(RegisteredService svc) {
        RegisteredServiceEditBean serviceBean = new RegisteredServiceEditBean();
        ServiceData bean = serviceBean.getServiceData();
        bean.setAssignedId(Long.toString(svc.getId()));
        bean.setServiceId(svc.getServiceId());
        bean.setName(svc.getName());
        bean.setDescription(svc.getDescription());
        if (svc.getLogo() != null) {
            bean.setLogoUrl(svc.getLogo().toExternalForm());
        }
        bean.setRequiredHandlers(svc.getRequiredHandlers());
        RegisteredServiceEditBean.configureAccessStrategy((RegisteredService)svc, (ServiceData)bean);
        if (svc instanceof OAuthRegisteredCallbackAuthorizeService) {
            bean.setType(RegisteredServiceTypeEditBean.OAUTH_CALLBACK_AUTHZ.toString());
        }
        if (svc instanceof OAuthRegisteredService) {
            bean.setType(RegisteredServiceTypeEditBean.OAUTH.toString());
            OAuthRegisteredService oauth = (OAuthRegisteredService)svc;
            RegisteredServiceOAuthTypeEditBean oauthBean = bean.getOauth();
            oauthBean.setBypass(oauth.isBypassApprovalPrompt().booleanValue());
            oauthBean.setClientId(oauth.getClientId());
            oauthBean.setClientSecret(oauth.getClientSecret());
        }
        bean.setTheme(svc.getTheme());
        bean.setEvalOrder(svc.getEvaluationOrder());
        LogoutType logoutType = svc.getLogoutType();
        switch (1.$SwitchMap$org$jasig$cas$services$LogoutType[logoutType.ordinal()]) {
            case 1: {
                bean.setLogoutType(RegisteredServiceLogoutTypeEditBean.BACK.toString());
                break;
            }
            case 2: {
                bean.setLogoutType(RegisteredServiceLogoutTypeEditBean.FRONT.toString());
                break;
            }
            default: {
                bean.setLogoutType(RegisteredServiceLogoutTypeEditBean.NONE.toString());
            }
        }
        URL url = svc.getLogoutUrl();
        if (url != null) {
            bean.setLogoutUrl(url.toExternalForm());
        }
        RegisteredServiceUsernameAttributeProvider provider = svc.getUsernameAttributeProvider();
        RegisteredServiceUsernameAttributeProviderEditBean uBean = bean.getUserAttrProvider();
        RegisteredServiceEditBean.configureUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)provider, (RegisteredServiceUsernameAttributeProviderEditBean)uBean);
        RegisteredServicePublicKey key = svc.getPublicKey();
        RegisteredServicePublicKeyEditBean pBean = bean.getPublicKey();
        if (key != null) {
            pBean.setAlgorithm(key.getAlgorithm());
            pBean.setLocation(key.getLocation());
        }
        RegisteredServiceEditBean.configureProxyPolicy((RegisteredService)svc, (ServiceData)bean);
        RegisteredServiceEditBean.configureAttributeReleasePolicy((RegisteredService)svc, (ServiceData)bean);
        return serviceBean;
    }

    private static void configureAccessStrategy(RegisteredService svc, ServiceData bean) {
        DefaultRegisteredServiceAccessStrategy accessStrategy = (DefaultRegisteredServiceAccessStrategy)svc.getAccessStrategy();
        RegisteredServiceSupportAccessEditBean accessBean = bean.getSupportAccess();
        accessBean.setCasEnabled(accessStrategy.isServiceAccessAllowed());
        accessBean.setSsoEnabled(accessStrategy.isServiceAccessAllowedForSso());
        accessBean.setRequireAll(accessStrategy.isRequireAllAttributes());
        accessBean.setRequiredAttr(accessStrategy.getRequiredAttributes());
        accessBean.setEndingTime(accessStrategy.getEndingDateTime());
        accessBean.setStartingTime(accessStrategy.getStartingDateTime());
    }

    private static void configureAttributeReleasePolicy(RegisteredService svc, ServiceData bean) {
        AbstractAttributeReleasePolicy attrPolicy = (AbstractAttributeReleasePolicy)svc.getAttributeReleasePolicy();
        if (attrPolicy != null) {
            ReturnAllowedAttributeReleasePolicy attrPolicyAllowed;
            PrincipalAttributesRepository pr;
            RegisteredServiceAttributeReleasePolicyEditBean attrPolicyBean = bean.getAttrRelease();
            attrPolicyBean.setReleasePassword(attrPolicy.isAuthorizedToReleaseCredentialPassword());
            attrPolicyBean.setReleaseTicket(attrPolicy.isAuthorizedToReleaseProxyGrantingTicket());
            AttributeFilter filter = attrPolicy.getAttributeFilter();
            if (filter != null && filter instanceof RegisteredServiceRegexAttributeFilter) {
                RegisteredServiceRegexAttributeFilter regex = (RegisteredServiceRegexAttributeFilter)filter;
                attrPolicyBean.setAttrFilter(regex.getPattern().pattern());
            }
            if ((pr = attrPolicy.getPrincipalAttributesRepository()) instanceof DefaultPrincipalAttributesRepository) {
                attrPolicyBean.setAttrOption(RegisteredServiceAttributeReleasePolicyEditBean.Types.DEFAULT.toString());
            } else if (pr instanceof CachingPrincipalAttributesRepository) {
                attrPolicyBean.setAttrOption(RegisteredServiceAttributeReleasePolicyEditBean.Types.CACHED.toString());
                CachingPrincipalAttributesRepository cc = (CachingPrincipalAttributesRepository)pr;
                Duration duration = cc.getDuration();
                attrPolicyBean.setCachedExpiration(duration.getDurationAmount());
                attrPolicyBean.setCachedTimeUnit(duration.getTimeUnit().name());
                IAttributeMerger merger = cc.getMergingStrategy().getAttributeMerger();
                if (merger != null) {
                    if (merger instanceof NoncollidingAttributeAdder) {
                        attrPolicyBean.setMergingStrategy(RegisteredServiceAttributeReleasePolicyEditBean.AttributeMergerTypes.ADD.toString());
                    } else if (merger instanceof MultivaluedAttributeMerger) {
                        attrPolicyBean.setMergingStrategy(RegisteredServiceAttributeReleasePolicyEditBean.AttributeMergerTypes.MULTIVALUED.toString());
                    } else if (merger instanceof ReplacingAttributeAdder) {
                        attrPolicyBean.setMergingStrategy(RegisteredServiceAttributeReleasePolicyEditBean.AttributeMergerTypes.REPLACE.toString());
                    }
                }
            }
            RegisteredServiceAttributeReleasePolicyStrategyEditBean sBean = attrPolicyBean.getAttrPolicy();
            if (attrPolicy instanceof ReturnAllAttributeReleasePolicy) {
                sBean.setType(AbstractRegisteredServiceAttributeReleasePolicyStrategyBean.Types.ALL.toString());
            } else if (attrPolicy instanceof ReturnAllowedAttributeReleasePolicy) {
                attrPolicyAllowed = (ReturnAllowedAttributeReleasePolicy)attrPolicy;
                sBean.setType(AbstractRegisteredServiceAttributeReleasePolicyStrategyBean.Types.ALLOWED.toString());
                sBean.setAttributes((Object)attrPolicyAllowed.getAllowedAttributes());
            } else if (attrPolicy instanceof ReturnMappedAttributeReleasePolicy) {
                attrPolicyAllowed = (ReturnMappedAttributeReleasePolicy)attrPolicy;
                sBean.setType(AbstractRegisteredServiceAttributeReleasePolicyStrategyBean.Types.MAPPED.toString());
                sBean.setAttributes((Object)attrPolicyAllowed.getAllowedAttributes());
            }
        }
    }

    private static void configureProxyPolicy(RegisteredService svc, ServiceData bean) {
        RegisteredServiceProxyPolicy policy = svc.getProxyPolicy();
        RegisteredServiceProxyPolicyBean cBean = bean.getProxyPolicy();
        if (policy == null || policy instanceof RefuseRegisteredServiceProxyPolicy) {
            cBean.setType(RegisteredServiceProxyPolicyBean.Types.REFUSE.toString());
        } else if (policy instanceof RegexMatchingRegisteredServiceProxyPolicy) {
            RegexMatchingRegisteredServiceProxyPolicy regex = (RegexMatchingRegisteredServiceProxyPolicy)policy;
            cBean.setType(RegisteredServiceProxyPolicyBean.Types.REGEX.toString());
            cBean.setValue(regex.getPattern().toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void configureUsernameAttributeProvider(RegisteredServiceUsernameAttributeProvider provider, RegisteredServiceUsernameAttributeProviderEditBean uBean) {
        if (provider instanceof DefaultRegisteredServiceUsernameProvider) {
            uBean.setType(RegisteredServiceUsernameAttributeProviderEditBean.Types.DEFAULT.toString());
            return;
        } else if (provider instanceof AnonymousRegisteredServiceUsernameAttributeProvider) {
            AnonymousRegisteredServiceUsernameAttributeProvider anonymous = (AnonymousRegisteredServiceUsernameAttributeProvider)provider;
            uBean.setType(RegisteredServiceUsernameAttributeProviderEditBean.Types.ANONYMOUS.toString());
            PersistentIdGenerator generator = anonymous.getPersistentIdGenerator();
            if (!(generator instanceof ShibbolethCompatiblePersistentIdGenerator)) return;
            ShibbolethCompatiblePersistentIdGenerator sh = (ShibbolethCompatiblePersistentIdGenerator)generator;
            byte[] saltByte = sh.getSalt();
            if (saltByte == null) throw new IllegalArgumentException("Salt cannot be null");
            String salt = new String(saltByte, Charset.defaultCharset());
            uBean.setValue(salt);
            return;
        } else {
            if (!(provider instanceof PrincipalAttributeRegisteredServiceUsernameProvider)) return;
            PrincipalAttributeRegisteredServiceUsernameProvider p = (PrincipalAttributeRegisteredServiceUsernameProvider)provider;
            uBean.setType(RegisteredServiceUsernameAttributeProviderEditBean.Types.ATTRIBUTE.toString());
            uBean.setValue(p.getUsernameAttribute());
        }
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }
}

