/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.principal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.principal.DefaultPrincipalFactory;
import org.jasig.cas.authentication.principal.PersonDirectoryPrincipalResolver$AjcClosure1;
import org.jasig.cas.authentication.principal.PersonDirectoryPrincipalResolver$AjcClosure3;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.PrincipalFactory;
import org.jasig.cas.authentication.principal.PrincipalResolver;
import org.jasig.cas.util.Pair;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.jasig.services.persondir.IPersonAttributeDao;
import org.jasig.services.persondir.IPersonAttributes;
import org.jasig.services.persondir.support.StubPersonAttributeDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="personDirectoryPrincipalResolver")
public class PersonDirectoryPrincipalResolver
implements PrincipalResolver {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    protected IPersonAttributeDao attributeRepository = new StubPersonAttributeDao(new HashMap());
    @NotNull
    protected PrincipalFactory principalFactory = new DefaultPrincipalFactory();
    @Value(value="${cas.principal.resolver.persondir.return.null:false}")
    protected boolean returnNullIfNoAttributes;
    protected String principalAttributeName;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    @Autowired
    public final void setAttributeRepository(@Qualifier(value="attributeRepository") IPersonAttributeDao attributeRepository) {
        this.attributeRepository = attributeRepository;
    }

    public void setReturnNullIfNoAttributes(boolean returnNullIfNoAttributes) {
        this.returnNullIfNoAttributes = returnNullIfNoAttributes;
    }

    @Autowired
    public void setPrincipalAttributeName(@Value(value="${cas.principal.resolver.persondir.principal.attribute:}") String attribute) {
        this.principalAttributeName = attribute;
    }

    @Autowired
    public void setPrincipalFactory(@Qualifier(value="principalFactory") PrincipalFactory principalFactory) {
        this.principalFactory = principalFactory;
    }

    public boolean supports(Credential credential) {
        Credential credential2 = credential;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)credential2);
        Object[] objectArray = new Object[]{this, credential2, joinPoint};
        return Conversions.booleanValue((Object)TraceLogAspect.aspectOf().traceMethod(new PersonDirectoryPrincipalResolver$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648)));
    }

    public Principal resolve(Credential credential) {
        Credential credential2 = credential;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)credential2);
        Object[] objectArray = new Object[]{this, credential2, joinPoint};
        return (Principal)TraceLogAspect.aspectOf().traceMethod(new PersonDirectoryPrincipalResolver$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    protected Pair<String, Map<String, Object>> convertPersonAttributesToPrincipal(String extractedPrincipalId, Map<String, List<Object>> attributes) {
        HashMap<String, Object> convertedAttributes = new HashMap<String, Object>();
        String principalId = extractedPrincipalId;
        for (Map.Entry<String, List<Object>> entry : attributes.entrySet()) {
            String key = entry.getKey();
            List<Object> values = entry.getValue();
            if (StringUtils.isNotBlank((CharSequence)this.principalAttributeName) && key.equalsIgnoreCase(this.principalAttributeName)) {
                if (values.isEmpty()) {
                    this.logger.debug("{} is empty, using {} for principal", (Object)this.principalAttributeName, (Object)extractedPrincipalId);
                    continue;
                }
                principalId = values.get(0).toString();
                this.logger.debug("Found principal attribute value {}; removing {} from attribute map.", (Object)extractedPrincipalId, (Object)this.principalAttributeName);
                continue;
            }
            convertedAttributes.put(key, values.size() == 1 ? values.get(0) : values);
        }
        return new Pair((Object)principalId, convertedAttributes);
    }

    protected Map<String, List<Object>> retrievePersonAttributes(String principalId, Credential credential) {
        IPersonAttributes personAttributes = this.attributeRepository.getPerson(principalId);
        Map attributes = personAttributes == null ? null : personAttributes.getAttributes();
        return attributes;
    }

    protected String extractPrincipalId(Credential credential) {
        return credential.getId();
    }

    static {
        PersonDirectoryPrincipalResolver.ajc$preClinit();
    }

    static final /* synthetic */ boolean supports_aroundBody0(PersonDirectoryPrincipalResolver ajc$this, Credential credential, JoinPoint joinPoint) {
        return credential != null && credential.getId() != null;
    }

    static final /* synthetic */ Principal resolve_aroundBody2(PersonDirectoryPrincipalResolver ajc$this, Credential credential, JoinPoint joinPoint) {
        ajc$this.logger.debug("Attempting to resolve a principal...");
        String principalId = ajc$this.extractPrincipalId(credential);
        if (principalId == null) {
            ajc$this.logger.debug("Got null for extracted principal ID; returning null.");
            return null;
        }
        ajc$this.logger.debug("Creating SimplePrincipal for [{}]", (Object)principalId);
        Map<String, List<Object>> attributes = ajc$this.retrievePersonAttributes(principalId, credential);
        if (attributes == null || attributes.isEmpty()) {
            ajc$this.logger.debug("Principal id [{}] did not specify any attributes", (Object)principalId);
            if (!ajc$this.returnNullIfNoAttributes) {
                ajc$this.logger.debug("Returning the principal with id [{}] without any attributes", (Object)principalId);
                return ajc$this.principalFactory.createPrincipal(principalId);
            }
            ajc$this.logger.debug("[{}] is configured to return null if no attributes are found for [{}]", (Object)ajc$this.getClass().getName(), (Object)principalId);
            return null;
        }
        ajc$this.logger.debug("Retrieved [{}] attribute(s) from the repository", (Object)attributes.size());
        Pair<String, Map<String, Object>> pair = ajc$this.convertPersonAttributesToPrincipal(principalId, attributes);
        return ajc$this.principalFactory.createPrincipal((String)pair.getFirst(), (Map)pair.getSecond());
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PersonDirectoryPrincipalResolver.java", PersonDirectoryPrincipalResolver.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supports", "org.jasig.cas.authentication.principal.PersonDirectoryPrincipalResolver", "org.jasig.cas.authentication.Credential", "credential", "", "boolean"), 91);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "resolve", "org.jasig.cas.authentication.principal.PersonDirectoryPrincipalResolver", "org.jasig.cas.authentication.Credential", "credential", "", "org.jasig.cas.authentication.principal.Principal"), 96);
    }
}

