/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util.services;

import java.security.PublicKey;
import javax.crypto.Cipher;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.RegisteredServiceCipherExecutor;
import org.jasig.cas.util.CompressionUtils;
import org.jasig.cas.util.services.DefaultRegisteredServiceCipherExecutor$AjcClosure1;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="registeredServiceCipherExecutor")
public class DefaultRegisteredServiceCipherExecutor
implements RegisteredServiceCipherExecutor {
    private static final String UTF8_ENCODING = "UTF-8";
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public final String encode(String data, RegisteredService service) {
        String string = data;
        RegisteredService registeredService = service;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string, (Object)registeredService);
        Object[] objectArray = new Object[]{this, string, registeredService, joinPoint};
        return (String)TraceLogAspect.aspectOf().traceMethod(new DefaultRegisteredServiceCipherExecutor$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    protected byte[] encodeInternal(String data, PublicKey publicKey, RegisteredService registeredService) {
        try {
            Cipher cipher = this.initializeCipherBasedOnServicePublicKey(publicKey, registeredService);
            if (cipher != null) {
                return cipher.doFinal(data.getBytes(UTF8_ENCODING));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private PublicKey createRegisteredServicePublicKey(RegisteredService registeredService) throws Exception {
        if (registeredService.getPublicKey() == null) {
            this.logger.debug("No public key is defined for service [{}]. No encoding will take place.", (Object)registeredService);
            return null;
        }
        PublicKey publicKey = registeredService.getPublicKey().createInstance();
        if (publicKey == null) {
            this.logger.debug("No public key instance created for service [{}]. No encoding will take place.", (Object)registeredService);
            return null;
        }
        return publicKey;
    }

    private Cipher initializeCipherBasedOnServicePublicKey(PublicKey publicKey, RegisteredService registeredService) {
        try {
            this.logger.debug("Using public key [{}] to initialize the cipher", (Object)registeredService.getPublicKey());
            Cipher cipher = Cipher.getInstance(publicKey.getAlgorithm());
            cipher.init(1, publicKey);
            this.logger.debug("Initialized cipher in encrypt-mode via the public key algorithm [{}]", (Object)publicKey.getAlgorithm());
            return cipher;
        }
        catch (Exception e) {
            this.logger.warn("Cipher could not be initialized for service [{}]. Error [{}]", (Object)registeredService, (Object)e.getMessage());
            return null;
        }
    }

    static {
        DefaultRegisteredServiceCipherExecutor.ajc$preClinit();
    }

    static final /* synthetic */ String encode_aroundBody0(DefaultRegisteredServiceCipherExecutor ajc$this, String data, RegisteredService service, JoinPoint joinPoint) {
        try {
            PublicKey publicKey = ajc$this.createRegisteredServicePublicKey(service);
            byte[] result = ajc$this.encodeInternal(data, publicKey, service);
            if (result != null) {
                return CompressionUtils.encodeBase64((byte[])result);
            }
        }
        catch (Exception e) {
            ajc$this.logger.warn(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DefaultRegisteredServiceCipherExecutor.java", DefaultRegisteredServiceCipherExecutor.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "encode", "org.jasig.cas.util.services.DefaultRegisteredServiceCipherExecutor", "java.lang.String:org.jasig.cas.services.RegisteredService", "data:service", "", "java.lang.String"), 27);
    }
}

