/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util;

import java.security.Key;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.util.AbstractCipherExecutor;
import org.jasig.cas.util.BaseStringCipherExecutor$AjcClosure1;
import org.jasig.cas.util.BaseStringCipherExecutor$AjcClosure3;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.OctJwkGenerator;
import org.jose4j.jwk.OctetSequenceJsonWebKey;

public class BaseStringCipherExecutor
extends AbstractCipherExecutor<String, String> {
    private static final int ENCRYPTION_KEY_SIZE = 256;
    private static final int SIGNING_KEY_SIZE = 512;
    private String contentEncryptionAlgorithmIdentifier;
    private Key secretKeyEncryptionKey;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    private BaseStringCipherExecutor() {
    }

    public BaseStringCipherExecutor(String secretKeyEncryption, String secretKeySigning) {
        this(secretKeyEncryption, secretKeySigning, "A128CBC-HS256");
    }

    public BaseStringCipherExecutor(String secretKeyEncryption, String secretKeySigning, String contentEncryptionAlgorithmIdentifier) {
        String signingKeyToUse;
        if (StringUtils.isBlank((CharSequence)contentEncryptionAlgorithmIdentifier)) {
            this.logger.debug("contentEncryptionAlgorithmIdentifier is not defined");
            return;
        }
        String secretKeyToUse = secretKeyEncryption;
        if (StringUtils.isBlank((CharSequence)secretKeyToUse)) {
            this.logger.warn("Secret key for encryption is not defined. CAS will attempt to auto-generate the encryption key");
            secretKeyToUse = this.generateOctetJsonWebKeyOfSize(256);
            this.logger.warn("Generated encryption key {} of size {}. The generated key MUST be added to CAS settings.", (Object)secretKeyToUse, (Object)256);
        }
        if (StringUtils.isBlank((CharSequence)(signingKeyToUse = secretKeySigning))) {
            this.logger.warn("Secret key for signing is not defined. CAS will attempt to auto-generate the signing key");
            signingKeyToUse = this.generateOctetJsonWebKeyOfSize(512);
            this.logger.warn("Generated signing key {} of size {}. The generated key MUST be added to CAS settings.", (Object)signingKeyToUse, (Object)512);
        }
        this.setSigningKey(signingKeyToUse);
        this.secretKeyEncryptionKey = this.prepareJsonWebTokenKey(secretKeyToUse);
        this.contentEncryptionAlgorithmIdentifier = contentEncryptionAlgorithmIdentifier;
        this.logger.debug("Initialized cipher encryption sequence via [{}]", (Object)contentEncryptionAlgorithmIdentifier);
    }

    public String encode(String value) {
        String string = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (String)TraceLogAspect.aspectOf().traceMethod(new BaseStringCipherExecutor$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    public String decode(String value) {
        String string = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (String)TraceLogAspect.aspectOf().traceMethod(new BaseStringCipherExecutor$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    private Key prepareJsonWebTokenKey(String secret) {
        try {
            HashMap<String, String> keys = new HashMap<String, String>(2);
            keys.put("kty", "oct");
            keys.put("k", secret);
            JsonWebKey jwk = JsonWebKey.Factory.newJwk(keys);
            return jwk.getKey();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private String encryptValue(@NotNull String value) {
        try {
            JsonWebEncryption jwe = new JsonWebEncryption();
            jwe.setPayload(value);
            jwe.setAlgorithmHeaderValue("dir");
            jwe.setEncryptionMethodHeaderParameter(this.contentEncryptionAlgorithmIdentifier);
            jwe.setKey(this.secretKeyEncryptionKey);
            this.logger.debug("Encrypting via [{}]", (Object)this.contentEncryptionAlgorithmIdentifier);
            return jwe.getCompactSerialization();
        }
        catch (Exception e) {
            throw new RuntimeException("Ensure that you have installed JCE Unlimited Strength Jurisdiction Policy Files. " + e.getMessage(), e);
        }
    }

    private String decryptValue(@NotNull String value) {
        try {
            JsonWebEncryption jwe = new JsonWebEncryption();
            jwe.setKey(this.secretKeyEncryptionKey);
            jwe.setCompactSerialization(value);
            this.logger.debug("Decrypting value...");
            return jwe.getPayload();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String generateOctetJsonWebKeyOfSize(int size) {
        OctetSequenceJsonWebKey octetKey = OctJwkGenerator.generateJwk((int)size);
        Map params = octetKey.toParams(JsonWebKey.OutputControlLevel.INCLUDE_SYMMETRIC);
        return params.get("k").toString();
    }

    static {
        BaseStringCipherExecutor.ajc$preClinit();
    }

    static final /* synthetic */ String encode_aroundBody0(BaseStringCipherExecutor ajc$this, String value, JoinPoint joinPoint) {
        String encoded = ajc$this.encryptValue(value);
        String signed = new String(ajc$this.sign(encoded.getBytes()));
        return signed;
    }

    static final /* synthetic */ String decode_aroundBody2(BaseStringCipherExecutor ajc$this, String value, JoinPoint joinPoint) {
        byte[] encoded = ajc$this.verifySignature(value.getBytes());
        if (encoded != null && encoded.length > 0) {
            return ajc$this.decryptValue(new String(encoded));
        }
        return null;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("BaseStringCipherExecutor.java", BaseStringCipherExecutor.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "encode", "org.jasig.cas.util.BaseStringCipherExecutor", "java.lang.String", "value", "", "java.lang.String"), 96);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "decode", "org.jasig.cas.util.BaseStringCipherExecutor", "java.lang.String", "value", "", "java.lang.String"), 103);
    }
}

