/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util;

import java.util.Map;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.crypto.AesCipherService;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.util.AbstractCipherExecutor;
import org.jasig.cas.util.BinaryCipherExecutor$AjcClosure1;
import org.jasig.cas.util.BinaryCipherExecutor$AjcClosure3;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.OctJwkGenerator;
import org.jose4j.jwk.OctetSequenceJsonWebKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryCipherExecutor
extends AbstractCipherExecutor<byte[], byte[]> {
    private static final String UTF8_ENCODING = "UTF-8";
    private static final int SIGNING_KEY_SIZE = 512;
    private static final int ENCRYPTION_KEY_SIZE = 16;
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private String secretKeyAlgorithm = "AES";
    private String encryptionSecretKey;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public BinaryCipherExecutor(String encryptionSecretKey, String signingSecretKey) {
        this.verifyAndSetKeys(encryptionSecretKey, signingSecretKey);
    }

    private void verifyAndSetKeys(String encryptionSecretKey, String signingSecretKey) {
        String signingKeyToUse = signingSecretKey;
        if (StringUtils.isBlank((CharSequence)signingKeyToUse)) {
            this.logger.warn("Secret key for signing is not defined. CAS will attempt to auto-generate the signing key");
            signingKeyToUse = this.generateOctetJsonWebKeyOfSize(512);
            this.logger.warn("Generated signing key {} of size {}. The generated key MUST be added to CAS settings.", (Object)signingKeyToUse, (Object)512);
        }
        this.setSigningKey(signingKeyToUse);
        if (StringUtils.isBlank((CharSequence)encryptionSecretKey)) {
            this.logger.warn("No encryption key is defined. CAS will attempt to auto-generate keys");
            this.encryptionSecretKey = RandomStringUtils.randomAlphabetic((int)16);
            this.logger.warn("Generated encryption key {} of size {}. The generated key MUST be added to CAS settings.", (Object)this.encryptionSecretKey, (Object)16);
        } else {
            this.encryptionSecretKey = encryptionSecretKey;
        }
    }

    public void setSecretKeyAlgorithm(String secretKeyAlgorithm) {
        this.secretKeyAlgorithm = secretKeyAlgorithm;
    }

    public byte[] encode(byte[] value) {
        byte[] byArray = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)byArray);
        Object[] objectArray = new Object[]{this, byArray, joinPoint};
        return (byte[])TraceLogAspect.aspectOf().traceMethod(new BinaryCipherExecutor$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    public byte[] decode(byte[] value) {
        byte[] byArray = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)byArray);
        Object[] objectArray = new Object[]{this, byArray, joinPoint};
        return (byte[])TraceLogAspect.aspectOf().traceMethod(new BinaryCipherExecutor$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    private String generateOctetJsonWebKeyOfSize(int size) {
        OctetSequenceJsonWebKey octetKey = OctJwkGenerator.generateJwk((int)size);
        Map params = octetKey.toParams(JsonWebKey.OutputControlLevel.INCLUDE_SYMMETRIC);
        return params.get("k").toString();
    }

    static {
        BinaryCipherExecutor.ajc$preClinit();
    }

    static final /* synthetic */ byte[] encode_aroundBody0(BinaryCipherExecutor ajc$this, byte[] value, JoinPoint joinPoint) {
        try {
            SecretKeySpec key = new SecretKeySpec(ajc$this.encryptionSecretKey.getBytes(), ajc$this.secretKeyAlgorithm);
            AesCipherService cipher = new AesCipherService();
            byte[] result = cipher.encrypt(value, key.getEncoded()).getBytes();
            return ajc$this.sign(result);
        }
        catch (Exception e) {
            ajc$this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    static final /* synthetic */ byte[] decode_aroundBody2(BinaryCipherExecutor ajc$this, byte[] value, JoinPoint joinPoint) {
        try {
            byte[] verifiedValue = ajc$this.verifySignature(value);
            SecretKeySpec key = new SecretKeySpec(ajc$this.encryptionSecretKey.getBytes(UTF8_ENCODING), ajc$this.secretKeyAlgorithm);
            AesCipherService cipher = new AesCipherService();
            byte[] result = cipher.decrypt(verifiedValue, key.getEncoded()).getBytes();
            return result;
        }
        catch (Exception e) {
            ajc$this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("BinaryCipherExecutor.java", BinaryCipherExecutor.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "encode", "org.jasig.cas.util.BinaryCipherExecutor", "[B", "value", "", "[B"), 82);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "decode", "org.jasig.cas.util.BinaryCipherExecutor", "[B", "value", "", "[B"), 96);
    }
}

