/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.handler.support;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.inspektr.common.ioc.annotation.NotNull;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.jasig.cas.authentication.principal.UsernamePasswordCredentials;
import org.springframework.util.Assert;

public class JaasAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    private static final String DEFAULT_REALM = "CAS";
    @NotNull
    private String realm = "CAS";

    public JaasAuthenticationHandler() {
        Assert.notNull((Object)Configuration.getConfiguration(), (String)"Static Configuration cannot be null. Did you remember to specify \"java.security.auth.login.config\"?");
    }

    protected final boolean authenticateUsernamePasswordInternal(UsernamePasswordCredentials credentials) throws AuthenticationException {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Attempting authentication for: " + credentials.getUsername()));
            }
            LoginContext lc = new LoginContext(this.realm, new UsernamePasswordCallbackHandler(credentials.getUsername(), credentials.getPassword()));
            lc.login();
            lc.logout();
        }
        catch (LoginException fle) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Authentication failed for: " + credentials.getUsername()));
            }
            fle.printStackTrace();
            return false;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Authentication succeeded for: " + credentials.getUsername()));
        }
        return true;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    protected static final class UsernamePasswordCallbackHandler
    implements CallbackHandler {
        private final String userName;
        private final String password;

        protected UsernamePasswordCallbackHandler(String userName, String password) {
            this.userName = userName;
            this.password = password;
        }

        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                Callback callback = callbacks[i];
                if (callback.getClass().equals(NameCallback.class)) {
                    ((NameCallback)callback).setName(this.userName);
                    continue;
                }
                if (callback.getClass().equals(PasswordCallback.class)) {
                    ((PasswordCallback)callback).setPassword(this.password.toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "Unrecognized Callback");
            }
        }
    }
}

