/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.RegisteredServiceImpl;
import org.jasig.cas.services.ReloadableServicesManager;
import org.jasig.cas.services.ServiceRegistryDao;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultServicesManagerImpl
implements ReloadableServicesManager {
    private ServiceRegistryDao serviceRegistryDao;
    private ConcurrentHashMap<Long, RegisteredService> services = new ConcurrentHashMap();
    private RegisteredService disabledRegisteredService;

    public DefaultServicesManagerImpl(ServiceRegistryDao serviceRegistryDao) {
        this(serviceRegistryDao, new String[0]);
    }

    public DefaultServicesManagerImpl(ServiceRegistryDao serviceRegistryDao, String[] defaultAttributes) {
        Assert.notNull((Object)serviceRegistryDao, (String)"serviceRegistryDao cannot be null.");
        this.serviceRegistryDao = serviceRegistryDao;
        this.disabledRegisteredService = this.constructDefaultRegisteredService(defaultAttributes);
        this.load();
    }

    @Override
    @Transactional(readOnly=false)
    public synchronized RegisteredService delete(long id) {
        RegisteredService r = this.findServiceBy(id);
        if (r == null) {
            return null;
        }
        this.serviceRegistryDao.delete(r);
        this.services.remove(id);
        return r;
    }

    @Override
    public RegisteredService findServiceBy(Service service) {
        Collection<RegisteredService> c = this.services.values();
        if (c.isEmpty()) {
            return this.disabledRegisteredService;
        }
        for (RegisteredService r : c) {
            if (!r.matches(service)) continue;
            return r;
        }
        return null;
    }

    @Override
    public RegisteredService findServiceBy(long id) {
        RegisteredService r = this.services.get(id);
        try {
            return r == null ? null : (RegisteredService)r.clone();
        }
        catch (CloneNotSupportedException e) {
            return r;
        }
    }

    @Override
    public Collection<RegisteredService> getAllServices() {
        return Collections.unmodifiableCollection(this.services.values());
    }

    @Override
    public boolean matchesExistingService(Service service) {
        return this.findServiceBy(service) != null;
    }

    @Override
    @Transactional(readOnly=false)
    public synchronized void save(RegisteredService registeredService) {
        RegisteredService r = this.serviceRegistryDao.save(registeredService);
        this.services.put(r.getId(), r);
    }

    @Override
    public void reload() {
        this.load();
    }

    private void load() {
        ConcurrentHashMap<Long, RegisteredService> localServices = new ConcurrentHashMap<Long, RegisteredService>();
        for (RegisteredService r : this.serviceRegistryDao.load()) {
            localServices.put(r.getId(), r);
        }
        this.services = localServices;
    }

    private RegisteredService constructDefaultRegisteredService(String[] attributes) {
        RegisteredServiceImpl r = new RegisteredServiceImpl();
        r.setAllowedToProxy(true);
        r.setAnonymousAccess(false);
        r.setEnabled(true);
        r.setSsoEnabled(true);
        r.setAllowedAttributes(attributes);
        return r;
    }
}

