/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Table;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.ticket.AbstractTicket;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.TicketGrantingTicketImpl;
import org.springframework.util.Assert;

@Entity
@Table(name="SERVICETICKET")
public final class ServiceTicketImpl
extends AbstractTicket
implements ServiceTicket {
    private static final long serialVersionUID = 1296808733190507408L;
    @Lob
    @Column(name="SERVICE", nullable=false)
    private Service service;
    @Column(name="FROM_NEW_LOGIN", nullable=false)
    private boolean fromNewLogin;
    @Column(name="TICKET_ALREADY_GRANTED", nullable=false)
    private AtomicBoolean grantedTicketAlready = new AtomicBoolean(false);

    public ServiceTicketImpl() {
    }

    protected ServiceTicketImpl(String id, TicketGrantingTicketImpl ticket, Service service, boolean fromNewLogin, ExpirationPolicy policy) {
        super(id, ticket, policy);
        Assert.notNull((Object)ticket, (String)"ticket cannot be null");
        Assert.notNull((Object)service, (String)"service cannot be null");
        this.service = service;
        this.fromNewLogin = fromNewLogin;
    }

    public boolean isFromNewLogin() {
        return this.fromNewLogin;
    }

    public Service getService() {
        return this.service;
    }

    public boolean isValidFor(Service serviceToValidate) {
        this.updateState();
        return serviceToValidate.matches(this.service);
    }

    public TicketGrantingTicket grantTicketGrantingTicket(String id, Authentication authentication, ExpirationPolicy expirationPolicy) {
        if (this.grantedTicketAlready.getAndSet(true)) {
            throw new IllegalStateException("TicketGrantingTicket already generated for this ServiceTicket.  Cannot grant more than one TGT for ServiceTicket");
        }
        return new TicketGrantingTicketImpl(id, (TicketGrantingTicketImpl)this.getGrantingTicket(), authentication, expirationPolicy);
    }

    public Authentication getAuthentication() {
        return null;
    }

    public final boolean equals(Object object) {
        if (object == null || !(object instanceof ServiceTicket)) {
            return false;
        }
        Ticket serviceTicket = (Ticket)object;
        return serviceTicket.getId().equals(this.getId());
    }
}

