/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.registry.AbstractTicketRegistry;

public abstract class AbstractDistributedTicketRegistry
extends AbstractTicketRegistry {
    protected static final Method[] SERVICE_TICKET_METHODS = new Method[2];
    protected static final Method[] TICKET_GRANTING_TICKET_METHODS = new Method[2];
    protected final Log log = LogFactory.getLog(this.getClass());

    protected abstract void updateTicket(Ticket var1);

    protected Ticket getProxiedTicketInstance(Ticket ticket) {
        return (Ticket)ProxiedTicket.newInstance(ticket, this);
    }

    static {
        try {
            AbstractDistributedTicketRegistry.SERVICE_TICKET_METHODS[0] = ServiceTicket.class.getMethod("isValidFor", Service.class);
            AbstractDistributedTicketRegistry.SERVICE_TICKET_METHODS[1] = ServiceTicket.class.getMethod("grantTicketGrantingTicket", String.class, Authentication.class, ExpirationPolicy.class);
            AbstractDistributedTicketRegistry.TICKET_GRANTING_TICKET_METHODS[0] = TicketGrantingTicket.class.getMethod("expire", null);
            AbstractDistributedTicketRegistry.TICKET_GRANTING_TICKET_METHODS[1] = TicketGrantingTicket.class.getMethod("grantServiceTicket", String.class, Service.class, ExpirationPolicy.class, Boolean.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static final class ProxiedTicket
    implements InvocationHandler {
        private final Object ticket;
        private final AbstractDistributedTicketRegistry ticketRegistry;
        private final Method[] methods;

        public static Object newInstance(Object obj, AbstractDistributedTicketRegistry ticketRegistry) {
            if (obj == null) {
                return null;
            }
            return Proxy.newProxyInstance(obj.getClass().getClassLoader(), obj.getClass().getInterfaces(), (InvocationHandler)new ProxiedTicket(obj, ticketRegistry, obj instanceof ServiceTicket ? SERVICE_TICKET_METHODS : TICKET_GRANTING_TICKET_METHODS));
        }

        private ProxiedTicket(Object serviceTicket, AbstractDistributedTicketRegistry ticketRegistry, Method[] methods) {
            this.ticket = serviceTicket;
            this.ticketRegistry = ticketRegistry;
            this.methods = methods;
        }

        public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
            Object result = m.invoke(this.ticket, args);
            for (Method method : this.methods) {
                if (!method.equals(m)) continue;
                this.ticketRegistry.updateTicket((Ticket)this.ticket);
            }
            return result;
        }
    }
}

