/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import org.inspektr.common.ioc.annotation.NotNull;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.ticket.TicketException;
import org.jasig.cas.web.support.WebUtils;
import org.springframework.util.StringUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public abstract class AbstractNonInteractiveCredentialsAction
extends AbstractAction {
    @NotNull
    private CentralAuthenticationService centralAuthenticationService;

    protected final boolean isRenewPresent(RequestContext context) {
        return StringUtils.hasText((String)context.getRequestParameters().get("renew"));
    }

    protected final Event doExecute(RequestContext context) {
        Credentials credentials;
        block7: {
            credentials = this.constructCredentialsFromRequest(context);
            if (credentials == null) {
                return this.error();
            }
            String ticketGrantingTicketId = WebUtils.getTicketGrantingTicketId(context);
            WebApplicationService service = WebUtils.getService(context);
            if (this.isRenewPresent(context) && ticketGrantingTicketId != null && service != null) {
                try {
                    String serviceTicketId = this.centralAuthenticationService.grantServiceTicket(ticketGrantingTicketId, service, credentials);
                    WebUtils.putServiceTicketInRequestScope(context, serviceTicketId);
                    return this.result("warn");
                }
                catch (TicketException e) {
                    if (e.getCause() != null && AuthenticationException.class.isAssignableFrom(e.getCause().getClass())) {
                        this.onError(context, credentials);
                        return this.error();
                    }
                    this.centralAuthenticationService.destroyTicketGrantingTicket(ticketGrantingTicketId);
                    if (!this.logger.isDebugEnabled()) break block7;
                    this.logger.debug((Object)"Attempted to generate a ServiceTicket using renew=true with different credentials", (Throwable)e);
                }
            }
        }
        try {
            WebUtils.putTicketGrantingTicketInRequestScope(context, this.centralAuthenticationService.createTicketGrantingTicket(credentials));
            this.onSuccess(context, credentials);
            return this.success();
        }
        catch (TicketException e) {
            this.onError(context, credentials);
            return this.error();
        }
    }

    public final void setCentralAuthenticationService(CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }

    protected void onError(RequestContext context, Credentials credentials) {
    }

    protected void onSuccess(RequestContext context, Credentials credentials) {
    }

    protected abstract Credentials constructCredentialsFromRequest(RequestContext var1);
}

