/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services;

import java.util.Arrays;
import javax.persistence.Basic;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.services.RegisteredService;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

@Entity
public class RegisteredServiceImpl
implements RegisteredService {
    private static final long serialVersionUID = -5136788302682868276L;
    private static final PathMatcher PATH_MATCHER = new AntPathMatcher();
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long id = -1L;
    @Basic
    private String[] allowedAttributes = new String[0];
    private String description;
    private String serviceId;
    private String name;
    private String theme;
    private boolean allowedToProxy = true;
    private boolean enabled = true;
    private boolean ssoEnabled = true;
    private boolean anonymousAccess = false;
    private boolean ignoreAttributes = false;

    public boolean isAnonymousAccess() {
        return this.anonymousAccess;
    }

    public void setAnonymousAccess(boolean anonymousAccess) {
        this.anonymousAccess = anonymousAccess;
    }

    public String[] getAllowedAttributes() {
        return this.allowedAttributes != null ? this.allowedAttributes : new String[]{};
    }

    public long getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getName() {
        return this.name;
    }

    public String getTheme() {
        return this.theme;
    }

    public boolean isAllowedToProxy() {
        return this.allowedToProxy;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isSsoEnabled() {
        return this.ssoEnabled;
    }

    public boolean matches(Service service) {
        return service != null && PATH_MATCHER.match(this.serviceId.toLowerCase(), service.getId().toLowerCase());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.allowedAttributes);
        result = 31 * result + (this.allowedToProxy ? 1231 : 1237);
        result = 31 * result + (this.anonymousAccess ? 1231 : 1237);
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.enabled ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.serviceId == null ? 0 : this.serviceId.hashCode());
        result = 31 * result + (this.ssoEnabled ? 1231 : 1237);
        result = 31 * result + (this.theme == null ? 0 : this.theme.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisteredServiceImpl)) {
            return false;
        }
        RegisteredServiceImpl other = (RegisteredServiceImpl)obj;
        if (!Arrays.equals(this.allowedAttributes, other.allowedAttributes)) {
            return false;
        }
        if (this.allowedToProxy != other.allowedToProxy) {
            return false;
        }
        if (this.anonymousAccess != other.anonymousAccess) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.enabled != other.enabled) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.serviceId == null ? other.serviceId != null : !this.serviceId.equals(other.serviceId)) {
            return false;
        }
        if (this.ssoEnabled != other.ssoEnabled) {
            return false;
        }
        return !(this.theme == null ? other.theme != null : !this.theme.equals(other.theme));
    }

    public void setAllowedAttributes(String[] allowedAttributes) {
        this.allowedAttributes = allowedAttributes;
    }

    public void setAllowedToProxy(boolean allowedToProxy) {
        this.allowedToProxy = allowedToProxy;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setServiceId(String id) {
        this.serviceId = id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSsoEnabled(boolean ssoEnabled) {
        this.ssoEnabled = ssoEnabled;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public boolean isIgnoreAttributes() {
        return this.ignoreAttributes;
    }

    public void setIgnoreAttributes(boolean ignoreAttributes) {
        this.ignoreAttributes = ignoreAttributes;
    }

    public Object clone() throws CloneNotSupportedException {
        RegisteredServiceImpl registeredServiceImpl = new RegisteredServiceImpl();
        registeredServiceImpl.setAllowedAttributes(this.allowedAttributes);
        registeredServiceImpl.setAllowedToProxy(this.allowedToProxy);
        registeredServiceImpl.setDescription(this.description);
        registeredServiceImpl.setEnabled(this.enabled);
        registeredServiceImpl.setId(this.id);
        registeredServiceImpl.setName(this.name);
        registeredServiceImpl.setServiceId(this.serviceId);
        registeredServiceImpl.setSsoEnabled(this.ssoEnabled);
        registeredServiceImpl.setTheme(this.theme);
        registeredServiceImpl.setAnonymousAccess(this.anonymousAccess);
        registeredServiceImpl.setIgnoreAttributes(this.ignoreAttributes);
        return registeredServiceImpl;
    }
}

