/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.validation;

import java.util.Collections;
import java.util.List;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.validation.Assertion;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImmutableAssertionImpl
implements Assertion {
    private static final long serialVersionUID = -1921502350732798866L;
    private final List<Authentication> principals;
    private final boolean fromNewLogin;
    private final Service service;

    public ImmutableAssertionImpl(List<Authentication> principals, Service service, boolean fromNewLogin) {
        Assert.notNull(principals, (String)"principals cannot be null");
        Assert.notNull((Object)service, (String)"service cannot be null");
        Assert.notEmpty(principals, (String)"principals cannot be empty");
        this.principals = principals;
        this.service = service;
        this.fromNewLogin = fromNewLogin;
    }

    @Override
    public List<Authentication> getChainedAuthentications() {
        return Collections.unmodifiableList(this.principals);
    }

    @Override
    public boolean isFromNewLogin() {
        return this.fromNewLogin;
    }

    @Override
    public Service getService() {
        return this.service;
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().isAssignableFrom(o.getClass())) {
            return false;
        }
        Assertion a = (Assertion)o;
        return this.service.equals(a.getService()) && this.fromNewLogin == a.isFromNewLogin() && ((Object)this.principals).equals(a.getChainedAuthentications());
    }

    public int hashCode() {
        return 15 * this.service.hashCode() ^ ((Object)this.principals).hashCode();
    }

    public String toString() {
        return "[principals={" + this.principals.toString() + "} for service=" + this.service.toString() + "]";
    }
}

